/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.fun.util;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.UnBlockError;
import com.manatee.common.util.CollectionUtils;
import com.manatee.fun.domain.FunctionContent;
import com.manatee.process.domain.ErrorTrace;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class FunctionContentUtil {
    public static void addUnBlockError(FunctionContent content, String message, String name) {
        ErrorTrace errorTrace = content.getErrorTrace();
        if (errorTrace == null) {
            errorTrace = new ErrorTrace();
        }
        UnBlockError unBlockError = UnBlockError.buildFunctionUnBlockError(content, message, name);
        errorTrace.addUnBlockError(unBlockError);
    }

    public static String checkParamSize(FunctionContent functionContent, Integer minSize, Integer maxSize, String funName) {
        if (minSize < 0 || maxSize < 0 || minSize > maxSize) {
            return "\u53c2\u6570\u4e2a\u6570\u6821\u9a8c\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458";
        }
        List<Object> parameters = functionContent.getParameters();
        if (CollectionUtils.isEmpty(parameters) && minSize > 0) {
            return String.format("\u51fd\u6570\uff1a%s ,\u5165\u53c2\u4e2a\u6570\u9519\u8bef,\u53c2\u6570\u4e2a\u6570\u5fc5\u987b\u5927\u4e8e0", funName);
        }
        if (parameters.size() < minSize) {
            return String.format("\u51fd\u6570\uff1a%s ,\u5165\u53c2\u4e2a\u6570\u9519\u8bef,\u53c2\u6570\u4e2a\u6570\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e%s", funName, minSize);
        }
        if (parameters.size() > maxSize) {
            return String.format("\u51fd\u6570\uff1a%s ,\u5165\u53c2\u4e2a\u6570\u9519\u8bef,\u53c2\u6570\u4e2a\u6570\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e%s", funName, maxSize);
        }
        return null;
    }

    public static Boolean checkParamExist(FunctionContent functionContent, String funName) {
        List<Object> parameters = functionContent.getParameters();
        ArrayList<String> paramKeyList = new ArrayList<String>();
        for (int i = 0; i < parameters.size(); ++i) {
            Object parameter = functionContent.getParameter(i);
            if (!Objects.isNull(parameter)) continue;
            String paramKeys = functionContent.getParamKeys(i);
            paramKeyList.add(paramKeys);
        }
        if (CollectionUtils.isNotEmpty(paramKeyList)) {
            FunctionContentUtil.addUnBlockError(functionContent, String.format("\u51fd\u6570\uff1a%s\uff0c\u53c2\u6570:%s\u4e3anull", funName, JSONObject.toJSONString(paramKeyList)), funName);
            return false;
        }
        return true;
    }
}

