/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.util;

import com.manatee.common.util.DateUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class RelativeDateFormat {
    private static final long ONE_MINUTE = 60000L;
    private static final long ONE_HOUR = 3600000L;
    private static final long ONE_DAY = 86400000L;
    private static final String ONE_SECOND_AGO = "\u79d2\u524d";
    private static final String ONE_MINUTE_AGO = "\u5206\u949f\u524d";
    private static final String ONE_HOUR_AGO = "\u5c0f\u65f6\u524d";
    private static final String ONE_DAY_AGO = "\u5929\u524d";

    public static void main(String[] args) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:m:s");
        System.out.println(RelativeDateFormat.format(format.parse("2016-01-14 10:14:49")));
    }

    public static String format(Date date) {
        long delta = new Date().getTime() - date.getTime();
        if (delta < 60000L) {
            long seconds = RelativeDateFormat.toSeconds(delta);
            return (seconds <= 0L ? 1L : seconds) + ONE_SECOND_AGO;
        }
        if (delta < 2700000L) {
            long minutes = RelativeDateFormat.toMinutes(delta);
            return (minutes <= 0L ? 1L : minutes) + ONE_MINUTE_AGO;
        }
        if (delta < 86400000L) {
            long hours = RelativeDateFormat.toHours(delta);
            return (hours <= 0L ? 1L : hours) + ONE_HOUR_AGO;
        }
        Calendar cl = Calendar.getInstance();
        cl.add(5, -1);
        String now_date = DateUtils.DateToStr(cl.getTime(), "yyyy-MM-dd");
        Date start_d = DateUtils.StrToDate(now_date + " 00:00:00", "yyyy-MM-dd HH:mm:ss");
        Date end_d = DateUtils.StrToDate(now_date + " 23:59:59", "yyyy-MM-dd HH:mm:ss");
        if (date.getTime() > start_d.getTime() && date.getTime() < end_d.getTime()) {
            SimpleDateFormat format = new SimpleDateFormat("HH:mm");
            return "\u6628\u5929 " + format.format(date);
        }
        SimpleDateFormat format = new SimpleDateFormat("yy-M-d HH:mm");
        return format.format(date);
    }

    private static long toSeconds(long date) {
        return date / 1000L;
    }

    private static long toMinutes(long date) {
        return RelativeDateFormat.toSeconds(date) / 60L;
    }

    private static long toHours(long date) {
        return RelativeDateFormat.toMinutes(date) / 60L;
    }

    private static long toDays(long date) {
        return RelativeDateFormat.toHours(date) / 24L;
    }
}

