/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.camunda.process.runtime;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcode.iutil.IInputUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.TransactionContextFactory;
import org.camunda.bpm.engine.impl.cfg.standalone.StandaloneTransactionContextFactory;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.core.variable.CoreVariableInstance;
import org.camunda.bpm.engine.impl.core.variable.scope.AbstractVariableScope;
import org.camunda.bpm.engine.impl.core.variable.scope.SimpleVariableInstance;
import org.camunda.bpm.engine.impl.core.variable.scope.VariableInstanceFactory;
import org.camunda.bpm.engine.impl.core.variable.scope.VariableInstanceLifecycleListener;
import org.camunda.bpm.engine.impl.core.variable.scope.VariableStore;
import org.camunda.bpm.engine.impl.delegate.DefaultDelegateInterceptor;
import org.camunda.bpm.engine.impl.el.Expression;
import org.camunda.bpm.engine.impl.el.ExpressionManager;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.DelegateInterceptor;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.ConditionExpression;
import org.camunda.bpm.model.bpmn.instance.FlowNode;
import org.camunda.bpm.model.bpmn.instance.SequenceFlow;
import org.camunda.bpm.model.bpmn.instance.StartEvent;
import org.camunda.bpm.model.bpmn.instance.UserTask;
import org.springframework.stereotype.Service;

@Service
public class CamundaSpeculationProcess
implements IProcess {
    @Resource
    private ProcessConfUtil processConfUtil;
    @Resource
    protected IInputUtil inputUtil;
    @Resource
    protected IOutputUtil outputUtil;
    @Resource
    private VariableUtil variableUtil;
    @Resource
    private HistoryService historyService;
    @Resource
    private RepositoryService repositoryService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"processInstanceId"});
        String processInstanceId = this.variableUtil.calVarInConf(content, "processInstanceId");
        Map variables = this.inputUtil.getHandleObject(content, "dataHandle");
        String taskDefKey = this.variableUtil.calVarInConf(content, "taskDefKey");
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (processInstance == null) {
            return;
        }
        ArrayList<FlowNode> willPassNodeList = new ArrayList<FlowNode>();
        ArrayList<FlowNode> flowNodeList = new ArrayList<FlowNode>();
        BpmnModelInstance bpmnModelInstance = this.repositoryService.getBpmnModelInstance(processInstance.getProcessDefinitionId());
        if (StringUtils.isNotBlank((CharSequence)taskDefKey)) {
            FlowNode flowNode2 = (FlowNode)bpmnModelInstance.getModelElementById(taskDefKey);
            if (flowNode2 == null) {
                return;
            }
            flowNodeList.add(flowNode2);
        } else {
            Collection startEvents = bpmnModelInstance.getModelElementsByType(StartEvent.class);
            flowNodeList.addAll(startEvents);
        }
        VariableScope variableScope = this.createEnvironment();
        ArrayList willPassNodes = new ArrayList();
        try {
            List variableInstanceList = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstanceId).list();
            for (HistoricVariableInstance historicVariableInstance : variableInstanceList) {
                variableScope.setVariable(historicVariableInstance.getName(), historicVariableInstance.getValue());
            }
            if (variables != null) {
                variableScope.setVariables(variables);
            }
            this.speculation(flowNodeList, variableScope, willPassNodeList);
            willPassNodeList.forEach(flowNode -> {
                JSONObject r = new JSONObject();
                r.put("id", (Object)flowNode.getId());
                r.put("name", (Object)flowNode.getName());
                if (flowNode instanceof UserTask) {
                    UserTask userTask = (UserTask)flowNode;
                    String camundaAssignee = userTask.getCamundaAssignee();
                    if (StrUtil.startWith((CharSequence)camundaAssignee, (CharSequence)"${")) {
                        ExpressionManager expressionManager = new ExpressionManager(null);
                        Expression expression = expressionManager.createExpression(camundaAssignee);
                        Object value = null;
                        try {
                            value = expression.getValue(variableScope);
                            r.put("assignee", value);
                        }
                        catch (Exception e) {
                            r.put("assignee", (Object)camundaAssignee);
                        }
                    } else {
                        r.put("assignee", (Object)camundaAssignee);
                    }
                    r.put("candidateUsersList", (Object)userTask.getCamundaCandidateUsersList());
                    r.put("candidateGroupsList", (Object)userTask.getCamundaCandidateGroupsList());
                    r.put("candidateUsers", (Object)userTask.getCamundaCandidateUsers());
                    r.put("candidateGroups", (Object)userTask.getCamundaCandidateGroups());
                }
                willPassNodes.add(r);
            });
        }
        finally {
            this.removeEnvironment();
        }
        JSONObject result = new JSONObject();
        result.put("willPassNodeList", willPassNodes);
        this.outputUtil.putData(content, (Object)result);
    }

    private void speculation(Collection<FlowNode> flowNodes, VariableScope variableScope, List<FlowNode> willPassNodeList) {
        for (FlowNode flowNode : flowNodes) {
            ArrayList<FlowNode> nextFlowNodeList = new ArrayList<FlowNode>();
            Collection sequenceFlows = flowNode.getOutgoing();
            for (SequenceFlow sequenceFlow : sequenceFlows) {
                if (!this.checkSequenceFlowPass(sequenceFlow, variableScope)) continue;
                nextFlowNodeList.add(sequenceFlow.getTarget());
                willPassNodeList.add(sequenceFlow.getTarget());
            }
            if (nextFlowNodeList.isEmpty()) continue;
            this.speculation(nextFlowNodeList, variableScope, willPassNodeList);
        }
    }

    private boolean checkSequenceFlowPass(SequenceFlow sequenceFlow, VariableScope variableScope) {
        Expression expression;
        Object o;
        ExpressionManager expressionManager = new ExpressionManager(null);
        ConditionExpression conditionExpression = sequenceFlow.getConditionExpression();
        if (conditionExpression != null && StringUtils.isNotBlank((CharSequence)conditionExpression.getTextContent()) && (o = (expression = expressionManager.createExpression(conditionExpression.getTextContent())).getValue(variableScope)) instanceof Boolean) {
            return (Boolean)o;
        }
        return true;
    }

    private VariableScope createEnvironment() {
        ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)ProcessEngineConfiguration.createStandaloneProcessEngineConfiguration();
        processEngineConfiguration.setDelegateInterceptor((DelegateInterceptor)new DefaultDelegateInterceptor());
        processEngineConfiguration.setTransactionContextFactory((TransactionContextFactory)new StandaloneTransactionContextFactory());
        Context.setProcessEngineConfiguration((ProcessEngineConfigurationImpl)processEngineConfiguration);
        Context.setCommandContext((CommandContext)new CommandContext(Context.getProcessEngineConfiguration()));
        return this.createVariableScope();
    }

    private void removeEnvironment() {
        Context.removeProcessEngineConfiguration();
        Context.removeCommandContext();
    }

    private VariableScope createVariableScope() {
        return new AbstractVariableScope(){
            private VariableStore variableStore = new VariableStore();
            private VariableInstanceFactory variableInstanceFactory = SimpleVariableInstance.SimpleVariableInstanceFactory.INSTANCE;

            protected VariableStore<CoreVariableInstance> getVariableStore() {
                return this.variableStore;
            }

            protected VariableInstanceFactory<CoreVariableInstance> getVariableInstanceFactory() {
                return this.variableInstanceFactory;
            }

            protected List<VariableInstanceLifecycleListener<CoreVariableInstance>> getVariableInstanceLifecycleListeners() {
                return new ArrayList<VariableInstanceLifecycleListener<CoreVariableInstance>>();
            }

            public AbstractVariableScope getParentVariableScope() {
                return null;
            }
        };
    }

    public String getName() {
        return "camundaSpeculationProcess";
    }
}

