/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;

@Service
public class CacheRamUtil
implements InitializingBean {
    private Logger log = LoggerFactory.getLogger(CacheRamUtil.class);
    Map<String, Object> cache = new ConcurrentHashMap<String, Object>();
    Map<String, Long> timeCache = new ConcurrentHashMap<String, Long>();
    private String KEY_PREFIX = "c:";

    public Object getCache(String key) {
        key = this.KEY_PREFIX + key;
        return this.cache.get(key);
    }

    public void setCache(String key, Object value, Integer minute) {
        if (value == null) {
            return;
        }
        key = this.KEY_PREFIX + key;
        this.cache.put(key, value);
        Long endTime = System.currentTimeMillis() + (long)(minute * 60 * 1000);
        this.timeCache.put(key, endTime);
    }

    public void setCache(String key, Object value, Long second) {
        if (value == null) {
            return;
        }
        key = this.KEY_PREFIX + key;
        this.cache.put(key, value);
        Long endTime = System.currentTimeMillis() + second * 1000L;
        this.timeCache.put(key, endTime);
    }

    public void cleanCacheByKey(String key) {
        if (this.timeCache == null || this.timeCache.size() == 0) {
            return;
        }
        key = this.KEY_PREFIX + key;
        this.cache.remove(key);
        this.timeCache.remove(key);
    }

    public void cleanCache() {
        if (this.timeCache == null || this.timeCache.size() == 0) {
            return;
        }
        for (Map.Entry<String, Long> map : this.timeCache.entrySet()) {
            Long value = map.getValue();
            if (System.currentTimeMillis() <= value) continue;
            String key = map.getKey();
            this.cache.remove(key);
            this.timeCache.remove(key);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.init();
    }

    void init() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            CacheRamUtil.this.cleanCache();
                            Thread.sleep(10000L);
                        }
                    }
                    catch (Throwable e) {
                        CacheRamUtil.this.log.error("[CacheRamUtil.init]_exception", e);
                        continue;
                    }
                    break;
                }
            }
        }).start();
    }

    public static void main(String[] args) {
    }
}

