/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.sql.listener;

import com.manatee.common.domain.DatabaseTableFields;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcode.sql.MySqlParser;
import com.manatee.lowcode.sql.MySqlParserBaseListener;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public class CreateTableListener
extends MySqlParserBaseListener {
    private DatabaseTableFields databaseTableFields = new DatabaseTableFields();

    @Override
    public void enterQueryCreateTable(MySqlParser.QueryCreateTableContext ctx) {
        this.getTableNameFromSql(ctx.getRuleContexts(MySqlParser.TableNameContext.class));
    }

    private void getTableNameFromSql(List<MySqlParser.TableNameContext> ctx) {
        List<MySqlParser.TableNameContext> ruleContexts = ctx;
        for (MySqlParser.TableNameContext tableSource : ruleContexts) {
            this.databaseTableFields.setTableName(StrUtil.unWrap((CharSequence)tableSource.getText(), (char)'`'));
        }
    }

    @Override
    public void enterCopyCreateTable(MySqlParser.CopyCreateTableContext ctx) {
        super.enterCopyCreateTable(ctx);
        this.getTableNameFromSql(ctx.getRuleContexts(MySqlParser.TableNameContext.class));
    }

    @Override
    public void enterColumnCreateTable(MySqlParser.ColumnCreateTableContext ctx) {
        super.enterColumnCreateTable(ctx);
        this.getTableNameFromSql(ctx.getRuleContexts(MySqlParser.TableNameContext.class));
    }

    @Override
    public void enterCreateTablespaceInnodb(MySqlParser.CreateTablespaceInnodbContext ctx) {
        super.enterCreateTablespaceInnodb(ctx);
        this.getTableNameFromSql(ctx.getRuleContexts(MySqlParser.TableNameContext.class));
    }

    @Override
    public void enterCreateTablespaceNdb(MySqlParser.CreateTablespaceNdbContext ctx) {
        super.enterCreateTablespaceNdb(ctx);
        this.getTableNameFromSql(ctx.getRuleContexts(MySqlParser.TableNameContext.class));
    }

    @Override
    public void enterPrimaryKeyColumnConstraint(MySqlParser.PrimaryKeyColumnConstraintContext ctx) {
        TerminalNode key = ctx.KEY();
        TerminalNode primary = ctx.PRIMARY();
        super.enterPrimaryKeyColumnConstraint(ctx);
    }

    @Override
    public void enterPrimaryKeyTableConstraint(MySqlParser.PrimaryKeyTableConstraintContext ctx) {
        int childCount;
        super.enterPrimaryKeyTableConstraint(ctx);
        if ((ctx.getChildCount() == 3 || ctx.getChildCount() == 4) && (childCount = ctx.getChild(2).getChildCount()) == 3) {
            String text = ctx.getChild(2).getChild(1).getText();
            this.databaseTableFields.setPrimaryKey(StrUtil.unWrap((CharSequence)text, (char)'`'));
        }
    }

    @Override
    public void exitColumnDeclaration(MySqlParser.ColumnDeclarationContext ctx) {
        int childCount = ctx.getChildCount();
        if (childCount <= 0) {
            return;
        }
        ParseTree child = ctx.getChild(0);
        String text = child.getText();
        DatabaseTableFields.Field field = new DatabaseTableFields.Field();
        field.setName(StrUtil.unWrap((CharSequence)text, (char)'`'));
        ParseTree child2 = ctx.getChild(1);
        int childCount1 = child2.getChildCount();
        for (int i2 = 0; i2 < childCount1; ++i2) {
            ParseTree child1 = child2.getChild(i2);
            if (child1 instanceof MySqlParser.DataTypeContext) {
                int childCount3;
                int childCount2 = child1.getChildCount();
                field.setType(child1.getChild(0).getText());
                if (childCount2 > 1 && (childCount3 = child1.getChild(1).getChildCount()) > 1) {
                    field.setLength(Integer.valueOf(Integer.parseInt(child1.getChild(1).getChild(1).getText())));
                }
            }
            if (child1 instanceof MySqlParser.NullColumnConstraintContext) {
                field.setNullable(Boolean.valueOf(child1.getText().equals("NOT NULL")));
            }
            if (child1 instanceof MySqlParser.AutoIncrementColumnConstraintContext) {
                field.setAutoIncrement(true);
            }
            if (!(child1 instanceof MySqlParser.CommentColumnConstraintContext)) continue;
            field.setComment(StrUtil.unWrap((CharSequence)child1.getChild(1).getText(), (char)'\''));
        }
        this.databaseTableFields.addField(field);
        super.exitColumnDeclaration(ctx);
    }

    public DatabaseTableFields getDatabaseTableFields() {
        return this.databaseTableFields;
    }
}

