/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.projectconfdb;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.exception.BizException;
import com.manatee.lowcodedb.config.ManateeDataSourceManager;
import com.manatee.lowcodedb.newdb.tenant.manager.TenantManager;
import com.manatee.manager.SpringContextManager;
import com.manatee.process.ProcessDataSource;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class ProjectConfDBInit
implements InitializingBean,
ApplicationContextAware {
    private Logger log = LoggerFactory.getLogger(ProjectConfDBInit.class);
    @Value(value="${spring.datasource.type:}")
    private String datasourceType;
    @Resource
    private ProcessDataSource processDataSource;
    @Resource
    private TenantManager tenantManager;

    public void afterPropertiesSet() throws Exception {
        this.initProjectConfDBS();
    }

    private void initProjectConfDBS() {
        JSONArray allProjectConf;
        try {
            allProjectConf = this.processDataSource.getAllProjectConf();
        }
        catch (BizException e) {
            throw new RuntimeException(e);
        }
        if (allProjectConf != null && !allProjectConf.isEmpty()) {
            for (Object object : allProjectConf) {
                try {
                    JSONObject projectConf = new JSONObject((Map)object);
                    JSONObject globalConf = projectConf.getJSONObject("conf");
                    if (globalConf == null) continue;
                    this.initDbs(globalConf);
                    this.initTenantIsolation(globalConf);
                }
                catch (Exception e) {
                    this.log.error("\u521d\u59cb\u5316\u9879\u76ee\u914d\u7f6e\u5f02\u5e38", (Throwable)e);
                }
            }
        }
    }

    public void loadProjectConfDbsById(Long projectId) {
        try {
            JSONObject globalConf;
            JSONObject projectConf = this.processDataSource.getProjectConf(projectId);
            if (projectConf != null && !projectConf.isEmpty() && (globalConf = projectConf.getJSONObject("conf")) != null) {
                this.initDbs(globalConf);
                this.initTenantIsolation(globalConf);
            }
        }
        catch (BizException e) {
            this.log.error("\u52a0\u8f7d\u9879\u76eedbs\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    private void initDbs(JSONObject globalConf) {
        try {
            JSONArray dbs = globalConf.getJSONArray("dbs");
            if (dbs != null && dbs.size() > 0) {
                ManateeDataSourceManager.addProjectConfDbsV2(dbs, this.datasourceType);
            }
        }
        catch (Exception e) {
            this.log.error("\u521d\u59cb\u5316\u9879\u76ee\u6570\u636e\u5e93\u914d\u7f6e\u5f02\u5e38", (Throwable)e);
        }
    }

    private void initTenantIsolation(JSONObject globalConf) {
        try {
            JSONArray tenantIsolation;
            JSONObject saas = globalConf.getJSONObject("saas");
            if (saas != null && (tenantIsolation = saas.getJSONArray("tenant_isolation")) != null && tenantIsolation.size() > 0) {
                ArrayList<String> tableColumnName = new ArrayList<String>();
                ArrayList<String> properties = new ArrayList<String>();
                for (Object o : tenantIsolation) {
                    JSONObject jsonObj = (JSONObject)o;
                    tableColumnName.add(jsonObj.getString("db_field"));
                    properties.add(jsonObj.getString("param"));
                }
                this.tenantManager.addTenantIsolation(tableColumnName, properties);
            }
        }
        catch (Exception e) {
            this.log.error("\u521d\u59cb\u5316\u9879\u76ee\u79df\u6237\u9694\u79bb\u914d\u7f6e\u5f02\u5e38", (Throwable)e);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SpringContextManager.applicationContext = applicationContext;
    }
}

