/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.process;

import com.alibaba.fastjson.JSONArray;
import com.manatee.common.domain.DBQuery;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.lowcodedb.config.ManateeDataSource;
import com.manatee.lowcodedb.constant.DatabaseProductNameEnum;
import com.manatee.lowcodedb.manager.DBAopManager;
import com.manatee.lowcodedb.manager.DBManager;
import com.manatee.lowcodedb.newdb.DbSqlAopBo;
import com.manatee.lowcodedb.newdb.DbUtil;
import com.manatee.lowcodedb.newdb.ThreadLocalConnection;
import com.manatee.lowcodedb.newdb.ds.DSFactory;
import com.manatee.lowcodedb.newdb.ds.DataSourceWrapper;
import com.manatee.lowcodedb.process.DynamicDbProcess;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ManateeSqlProcess
implements IProcess {
    private static Logger LOGGER = LoggerFactory.getLogger(ManateeSqlProcess.class);
    @Value(value="${default-database-product-name:mysql}")
    private String defaultDatabaseProductName;
    @Resource
    private ProcessConfUtil processConfUtil;
    @Resource
    private DBManager dBManager;
    @Resource
    private DynamicDbProcess dynamicDbProcess;
    @Resource
    private IVariableUtil variableUtil;
    @Resource
    protected ManateeDataSource manateeDataSource;
    @Resource
    private DBAopManager dbAopManager;

    public void process(ProcessContent content) throws BizException {
        String db = this.variableUtil.calVarInConf(content, "db");
        Connection conn = null;
        DataSourceWrapper dataSource = (DataSourceWrapper)DSFactory.get(db);
        try {
            conn = dataSource.getConnection();
            String databaseProductName = conn.getMetaData().getDatabaseProductName().toLowerCase();
            String code = DatabaseProductNameEnum.getCodeByName(databaseProductName);
            if (StringUtils.isNotEmpty((CharSequence)code)) {
                this.defaultDatabaseProductName = code;
            }
        }
        catch (SQLException e) {
            try {
                throw new BizException(ResultCode.SYSTEM_ERROR, (Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(conn);
        this.setDatabaseSql(content);
        this.processConfUtil.checkConf(content, new String[]{"sql"});
        String originalSql = content.getStepConf().getString("sql");
        String sqlType = content.getStepConf().getString("sqlType");
        DbSqlAopBo dbSqlAopBo = new DbSqlAopBo();
        dbSqlAopBo.setSqlType(sqlType);
        dbSqlAopBo.setSql(originalSql);
        this.dbAopManager.sqlBeforeFun(content, dbSqlAopBo);
        DBQuery dbQuery = this.dBManager.getDBQuery(content, this.defaultDatabaseProductName);
        ThreadLocalConnection.INSTANCE.setProcessContent(content);
        try {
            this.dynamicDbProcess.executeSql(content, dbQuery);
        }
        catch (BizException e) {
            throw e;
        }
        finally {
            ThreadLocalConnection.INSTANCE.removeProcessContent();
        }
    }

    public String getName() {
        return "manateeSqlProcess";
    }

    private void setDatabaseSql(ProcessContent content) throws BizException {
        JSONArray sqlArray = content.getStepConf().getJSONArray("originalSqlArray");
        if (sqlArray == null || sqlArray.size() <= 0) {
            sqlArray = content.getStepConf().getJSONArray("sql");
            content.getStepConf().put("originalSqlArray", (Object)sqlArray);
        }
        String sql = null;
        HashMap<String, Integer> isRepeat = new HashMap<String, Integer>();
        for (int i = 0; i < sqlArray.size(); ++i) {
            String dbType = sqlArray.getJSONObject(i).get((Object)"dbType").toString();
            if (this.defaultDatabaseProductName.equals(dbType)) {
                sql = sqlArray.getJSONObject(i).getString("sql");
            }
            if (isRepeat.containsKey(dbType)) {
                throw new BizException(ResultCode.PARAM_IS_ERROR, "\u5b58\u5728\u91cd\u590d\u7c7b\u578bSQL\uff0c\u8bf7\u68c0\u67e5\u5220\u9664\u540e\u91cd\u8bd5");
            }
            isRepeat.put(dbType, 1);
        }
        if (sql != null) {
            sql = sql.trim();
            content.getStepConf().put("sql", (Object)sql);
            return;
        }
        throw new BizException(ResultCode.PARAM_IS_ERROR, "\u8bf7\u586b\u5199\u5bf9\u5e94\u6570\u636e\u5e93SQL\u8bed\u53e5");
    }
}

