/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.DBQuery;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.CloneUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.lowcode.util.OutputUtil;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.lowcodedb.config.ManateeDataSource;
import com.manatee.lowcodedb.config.ManateeDataSourceManager;
import com.manatee.lowcodedb.manager.DBAopManager;
import com.manatee.lowcodedb.manager.DBManager;
import com.manatee.lowcodedb.newdb.DbSqlAopBo;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import com.zaxxer.hikari.HikariDataSource;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.stereotype.Service;

@Service
public class DynamicDbProcess
implements IProcess {
    @Resource
    protected OutputUtil outputUtil;
    @Resource
    private DBManager dBManager;
    @Resource
    private ProcessConfUtil processConfUtil;
    @Resource
    private IVariableUtil variableUtil;
    @Resource
    private DBAopManager dbAopManager;

    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"sql"});
        String databaseProductName = this.variableUtil.calVarInConf(content, "databaseProductName");
        String url = this.variableUtil.calVarInConf(content, "url");
        String username = this.variableUtil.calVarInConf(content, "username");
        String password = this.variableUtil.calVarInConf(content, "password");
        if (!ManateeDataSource.getDataSourceNameSet().contains(url)) {
            DataSourceProperties dataSourceProperties = new DataSourceProperties();
            dataSourceProperties.setUsername(username);
            dataSourceProperties.setPassword(password);
            dataSourceProperties.setUrl(url);
            HikariDataSource hikariDataSource = ManateeDataSourceManager.create(dataSourceProperties);
            ManateeDataSource.addDataSource(url, (DataSource)hikariDataSource);
        }
        DBQuery dbQuery = this.dBManager.getDBQuery(content, databaseProductName);
        dbQuery.setDb(url);
        this.executeSql(content, dbQuery);
    }

    public void executeSql(ProcessContent content, DBQuery dbQuery) throws BizException {
        String sqlLower = dbQuery.getSql().toLowerCase();
        if (StringUtils.isNotBlank((String)dbQuery.getSqlType())) {
            if ("select".equalsIgnoreCase(dbQuery.getSqlType())) {
                this.executeQueryAndOutput(content, dbQuery);
            } else if ("UPDATE".equalsIgnoreCase(dbQuery.getSqlType()) || "DELETE".equalsIgnoreCase(dbQuery.getSqlType()) || "INSERT".equalsIgnoreCase(dbQuery.getSqlType())) {
                this.executeUpdateAndOutput(content, dbQuery);
            } else if ("stored_procedure".equalsIgnoreCase(dbQuery.getSqlType())) {
                this.executeCallAndOutput(content, dbQuery);
            } else {
                throw new BizException(ResultCode.CONF_ERROR);
            }
            return;
        }
        if (sqlLower.trim().startsWith("select ")) {
            this.executeQueryAndOutput(content, dbQuery);
        } else {
            this.executeUpdateAndOutput(content, dbQuery);
        }
    }

    private void executeQueryAndOutput(ProcessContent content, DBQuery dbQuery) throws BizException {
        JSONObject totalCountJson;
        DBQuery dbQueryForCount = dbQuery;
        if (dbQuery.getDatabaseProductName().equalsIgnoreCase("oracle")) {
            dbQueryForCount = (DBQuery)CloneUtil.cloneByStream((Object)dbQuery);
            this.jointOracleLimit(dbQuery);
        } else {
            this.jointLimit(dbQuery);
        }
        Boolean selectIsAddTransaction = content.getStepConf().getBoolean("selectIsAddTransaction");
        JSON data = selectIsAddTransaction != null && selectIsAddTransaction != false ? this.dBManager.executeSelectSqlV3(content, dbQuery) : this.dBManager.executeSelectSqlV2(content, dbQuery);
        DbSqlAopBo dbSqlAopBo = new DbSqlAopBo();
        dbSqlAopBo.setSqlType("select");
        dbSqlAopBo.setResultData(data);
        this.dbAopManager.sqlAfterFun(content, dbSqlAopBo);
        Long manateeProcessVersion = dbQuery.getManateeProcessVersion();
        if (data != null || manateeProcessVersion != null && manateeProcessVersion >= 321040100L) {
            Object returnDataShow = content.getStepConf().get((Object)"returnDataShow");
            if (returnDataShow != null && Boolean.valueOf(returnDataShow.toString()).booleanValue()) {
                this.outputUtil.setDefaultReturnKey(content, "outputData");
            }
            String syntaxType = content.getStepConf().getString("syntaxTypeDataProcess");
            this.outputUtil.handleAndPutDataV2(content, (Object)data, syntaxType);
        }
        if ((totalCountJson = this.dBManager.querySqlTotalCount(dbQueryForCount, content)) != null) {
            this.outputUtil.unfoldPutData(content, (Map)totalCountJson);
        }
    }

    private void executeUpdateAndOutput(ProcessContent content, DBQuery dbQuery) throws BizException {
        int count = this.dBManager.executeNotSelectSqlV2(content, dbQuery);
        this.outputUtil.setDefaultReturnKey(content, "count");
        this.outputUtil.putData(content, (Object)count);
    }

    private void executeCallAndOutput(ProcessContent content, DBQuery dbQuery) throws BizException {
        JSON data = this.dBManager.executeCallSql(content, dbQuery);
        DbSqlAopBo dbSqlAopBo = new DbSqlAopBo();
        dbSqlAopBo.setSqlType("stored_procedure");
        dbSqlAopBo.setResultData(data);
        this.dbAopManager.sqlAfterFun(content, dbSqlAopBo);
        if (data != null) {
            Object returnDataShow = content.getStepConf().get((Object)"returnDataShow");
            if (returnDataShow != null && Boolean.valueOf(returnDataShow.toString()).booleanValue()) {
                this.outputUtil.setDefaultReturnKey(content, "outputData");
            } else {
                this.outputUtil.setDefaultReturnKey(content, "outputUnfold");
            }
            this.outputUtil.handleAndPutData(content, (Object)data);
        }
    }

    private void jointLimit(DBQuery dbQuery) {
        StringBuilder sqlSb = new StringBuilder();
        sqlSb.append(dbQuery.getSql());
        Integer skip = null;
        if (dbQuery.getPage() != null) {
            Integer pageNum = dbQuery.getPage().getPageNum();
            Integer pageSize = dbQuery.getPage().getPageSize();
            if (pageNum != null && pageSize != null) {
                skip = (pageNum - 1) * pageSize;
            }
            if (skip != null && pageSize != null) {
                sqlSb.append(" limit ").append(skip).append(", ").append(pageSize);
            } else if (pageSize != null) {
                sqlSb.append(" limit ").append(pageSize);
            }
            dbQuery.setSql(sqlSb.toString());
        }
    }

    private void jointOracleLimit(DBQuery dbQuery) {
        String originSql = dbQuery.getSql();
        if (dbQuery.getPage() != null) {
            StringBuilder sqlSB = new StringBuilder();
            sqlSB.append("SELECT * FROM (SELECT temp.*, ROWNUM LOWCODE_RN FROM (").append(originSql);
            Integer pageNum = dbQuery.getPage().getPageNum();
            Integer pageSize = dbQuery.getPage().getPageSize();
            if (pageNum != null && pageSize != null) {
                Integer skip = (pageNum - 1) * pageSize;
                sqlSB.append(") temp WHERE ROWNUM <= " + (skip + pageSize) + ") WHERE LOWCODE_RN >= " + (skip + 1) + " ");
            } else if (pageNum == null && pageSize != null) {
                Integer skip = pageSize;
                sqlSB.append(") temp WHERE ROWNUM <= " + (skip + pageSize) + ") ");
            } else {
                sqlSB = new StringBuilder(originSql);
            }
            dbQuery.setSql(sqlSB.toString());
        }
    }

    public String getName() {
        return "dynamicDbProcess";
    }
}

