/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.newdb.dialect;

import com.manatee.common.util.tool.core.util.ClassLoaderUtil;
import com.manatee.common.util.tool.core.util.ReUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcode.db.DriverNamePool;
import com.manatee.lowcodedb.constant.DataBaseTypeEnum;
import com.manatee.lowcodedb.newdb.dialect.Dialect;
import com.manatee.lowcodedb.newdb.dialect.DriverUtil;
import com.manatee.lowcodedb.newdb.dialect.impl.AnsiSqlDialect;
import com.manatee.lowcodedb.newdb.dialect.impl.DmDialect;
import com.manatee.lowcodedb.newdb.dialect.impl.H2Dialect;
import com.manatee.lowcodedb.newdb.dialect.impl.KingbaseDialect;
import com.manatee.lowcodedb.newdb.dialect.impl.MysqlDialect;
import com.manatee.lowcodedb.newdb.dialect.impl.OracleDialect;
import com.manatee.lowcodedb.newdb.dialect.impl.PhoenixDialect;
import com.manatee.lowcodedb.newdb.dialect.impl.PostgresqlDialect;
import com.manatee.lowcodedb.newdb.dialect.impl.SqlServer2012Dialect;
import com.manatee.lowcodedb.newdb.dialect.impl.Sqlite3Dialect;
import com.manatee.lowcodedb.newdb.dialect.impl.StarRocksDialect;
import com.manatee.lowcodedb.newdb.dialect.impl.YashanDialect;
import java.sql.Connection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DialectFactory
implements DriverNamePool {
    private static final Logger LOGGER = LoggerFactory.getLogger(DialectFactory.class);
    private static final Map<DataSource, Dialect> DIALECT_POOL = new ConcurrentHashMap<DataSource, Dialect>();

    private DialectFactory() {
    }

    public static Dialect newDialect(String driverName) {
        Dialect dialect = DialectFactory.internalNewDialect(driverName);
        LOGGER.debug("Use Dialect: [{}].", (Object)dialect.getClass().getSimpleName());
        return dialect;
    }

    private static Dialect internalNewDialect(String driverName) {
        if (StrUtil.isNotBlank((CharSequence)driverName)) {
            if ("com.mysql.jdbc.Driver".equalsIgnoreCase(driverName) || "com.mysql.cj.jdbc.Driver".equalsIgnoreCase(driverName) || "ru.yandex.clickhouse.ClickHouseDriver".equalsIgnoreCase(driverName)) {
                return new MysqlDialect();
            }
            if ("oracle.jdbc.OracleDriver".equalsIgnoreCase(driverName) || "oracle.jdbc.driver.OracleDriver".equalsIgnoreCase(driverName)) {
                return new OracleDialect();
            }
            if ("org.sqlite.JDBC".equalsIgnoreCase(driverName)) {
                return new Sqlite3Dialect();
            }
            if ("org.postgresql.Driver".equalsIgnoreCase(driverName)) {
                return new PostgresqlDialect();
            }
            if ("org.h2.Driver".equalsIgnoreCase(driverName)) {
                return new H2Dialect();
            }
            if ("com.microsoft.sqlserver.jdbc.SQLServerDriver".equalsIgnoreCase(driverName)) {
                return new SqlServer2012Dialect();
            }
            if ("org.apache.phoenix.jdbc.PhoenixDriver".equalsIgnoreCase(driverName)) {
                return new PhoenixDialect();
            }
            if ("dm.jdbc.driver.DmDriver".equalsIgnoreCase(driverName)) {
                return new DmDialect();
            }
            if ("com.starrocks.jdbc.Driver".equalsIgnoreCase(driverName)) {
                return new StarRocksDialect();
            }
            if ("com.kingbase8.Driver".equalsIgnoreCase(driverName)) {
                return new KingbaseDialect();
            }
            if ("com.kingbase8.Driver".equalsIgnoreCase(driverName)) {
                return new KingbaseDialect();
            }
            if ("com.yashandb.jdbc.Driver".equalsIgnoreCase(driverName)) {
                return new YashanDialect();
            }
        }
        return new AnsiSqlDialect();
    }

    public static String identifyDriver(String nameContainsProductInfo) {
        return DialectFactory.identifyDriver(nameContainsProductInfo, null);
    }

    public static String identifyDriver(String nameContainsProductInfo, ClassLoader classLoader) {
        if (StrUtil.isBlank((CharSequence)nameContainsProductInfo)) {
            return null;
        }
        String name = ReUtil.getGroup1((String)"jdbc:(.*?):", (CharSequence)(nameContainsProductInfo = StrUtil.cleanBlank((CharSequence)nameContainsProductInfo.toLowerCase())));
        if (StrUtil.isNotBlank((CharSequence)name)) {
            nameContainsProductInfo = name;
        }
        String driver = null;
        if (nameContainsProductInfo.contains(DataBaseTypeEnum.MYSQL.getName()) || nameContainsProductInfo.contains(DataBaseTypeEnum.COBAR.getName())) {
            driver = ClassLoaderUtil.isPresent((String)"com.mysql.cj.jdbc.Driver", (ClassLoader)classLoader) ? "com.mysql.cj.jdbc.Driver" : "com.mysql.jdbc.Driver";
        } else if (nameContainsProductInfo.contains(DataBaseTypeEnum.ORACLE.getName())) {
            driver = ClassLoaderUtil.isPresent((String)"oracle.jdbc.OracleDriver", (ClassLoader)classLoader) ? "oracle.jdbc.OracleDriver" : "oracle.jdbc.driver.OracleDriver";
        } else if (nameContainsProductInfo.contains(DataBaseTypeEnum.POSTGRESQL.getName())) {
            driver = "org.postgresql.Driver";
        } else if (nameContainsProductInfo.contains(DataBaseTypeEnum.SQLITE.getName())) {
            driver = "org.sqlite.JDBC";
        } else if (nameContainsProductInfo.contains(DataBaseTypeEnum.SQLSERVER.getName()) || nameContainsProductInfo.contains(DataBaseTypeEnum.MICROSOFT.getName())) {
            driver = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
        } else if (nameContainsProductInfo.contains(DataBaseTypeEnum.HIVE2.getName())) {
            driver = "org.apache.hive.jdbc.HiveDriver";
        } else if (nameContainsProductInfo.contains(DataBaseTypeEnum.HIVE.getName())) {
            driver = "org.apache.hadoop.hive.jdbc.HiveDriver";
        } else if (nameContainsProductInfo.contains(DataBaseTypeEnum.H2.getName())) {
            driver = "org.h2.Driver";
        } else if (nameContainsProductInfo.contains(DataBaseTypeEnum.DERBY.getName())) {
            driver = "org.apache.derby.jdbc.AutoloadedDriver";
        } else if (nameContainsProductInfo.contains(DataBaseTypeEnum.HSQLDB.getName())) {
            driver = "org.hsqldb.jdbc.JDBCDriver";
        } else if (nameContainsProductInfo.contains(DataBaseTypeEnum.DM.getName())) {
            driver = "dm.jdbc.driver.DmDriver";
        } else if (nameContainsProductInfo.contains(DataBaseTypeEnum.KINGBASE8.getName()) || nameContainsProductInfo.contains(DataBaseTypeEnum.KINGBASEES.getName())) {
            driver = "com.kingbase8.Driver";
        } else if (nameContainsProductInfo.contains(DataBaseTypeEnum.IGNITE.getName())) {
            driver = "org.apache.ignite.IgniteJdbcThinDriver";
        } else if (nameContainsProductInfo.contains(DataBaseTypeEnum.CLICKHOUSE.getName())) {
            driver = "ru.yandex.clickhouse.ClickHouseDriver";
        } else if (nameContainsProductInfo.contains(DataBaseTypeEnum.HIGHGO.getName())) {
            driver = "com.highgo.jdbc.Driver";
        } else if (nameContainsProductInfo.contains(DataBaseTypeEnum.DB2.getName())) {
            driver = "com.ibm.db2.jdbc.app.DB2Driver";
        } else if (nameContainsProductInfo.contains(DataBaseTypeEnum.XUGU.getName())) {
            driver = "com.xugu.cloudjdbc.Driver";
        } else if (nameContainsProductInfo.contains(DataBaseTypeEnum.PHOENIX.getName())) {
            driver = "org.apache.phoenix.jdbc.PhoenixDriver";
        } else if (nameContainsProductInfo.contains(DataBaseTypeEnum.ZENITH.getName()) || nameContainsProductInfo.contains(DataBaseTypeEnum.GAUSS.getName())) {
            driver = "com.huawei.gauss.jdbc.ZenithDriver";
        } else if (nameContainsProductInfo.contains(DataBaseTypeEnum.GBASE.getName())) {
            driver = "com.gbase.jdbc.Driver";
        } else if (nameContainsProductInfo.contains(DataBaseTypeEnum.OSCAR.getName())) {
            driver = "com.oscar.Driver";
        } else if (nameContainsProductInfo.contains(DataBaseTypeEnum.SYBASE.getName())) {
            driver = "com.sybase.jdbc4.jdbc.SybDriver";
        } else if (nameContainsProductInfo.contains(DataBaseTypeEnum.MARIADB.getName())) {
            driver = "org.mariadb.jdbc.Driver";
        } else if (nameContainsProductInfo.contains(DataBaseTypeEnum.YASHANDB.getName())) {
            driver = "com.yashandb.jdbc.Driver";
        }
        return driver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dialect getDialect(DataSource ds) {
        Dialect dialect = DIALECT_POOL.get(ds);
        if (null == dialect) {
            DataSource dataSource = ds;
            synchronized (dataSource) {
                dialect = DIALECT_POOL.computeIfAbsent(ds, DialectFactory::newDialect);
            }
        }
        return dialect;
    }

    public static Dialect newDialect(DataSource ds) {
        return DialectFactory.newDialect(DriverUtil.identifyDriver(ds));
    }

    public static Dialect newDialect(Connection conn) {
        return DialectFactory.newDialect(DriverUtil.identifyDriver(conn));
    }
}

