/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.redis.util;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.util.StringUtil;
import com.manatee.redis.util.ManateeRedisUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.stereotype.Service;

@Service
public class ConfManager {
    private long UPDATE_TIME = 180000L;
    private Map<String, Long> TIME_MAP = new ConcurrentHashMap<String, Long>();
    private Map<String, JSONObject> VALUE_MAP = new HashMap<String, JSONObject>();
    private Integer db = 6;

    public JSONObject getData(String code) {
        JSONObject result = new JSONObject();
        Long lastTime = this.TIME_MAP.get(code);
        if (lastTime == null) {
            lastTime = 0L;
        }
        if (System.currentTimeMillis() - lastTime > this.UPDATE_TIME) {
            String value = this.getDataSource(code);
            if (StringUtil.isNotBlank((String)value)) {
                result = JSONObject.parseObject((String)value);
            }
            this.VALUE_MAP.put(code, result);
            this.TIME_MAP.put(code, System.currentTimeMillis());
        } else {
            result = this.VALUE_MAP.get(code);
        }
        return result;
    }

    public String getDataSource(String code) {
        return ManateeRedisUtil.getValue(this.db, code);
    }
}

