/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.template.process;

import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.tool.core.io.FileUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcode.iutil.IInputUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.iutil.IProcessConfUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TemplateEngineProcess
implements IProcess {
    private static Logger LOGGER = LoggerFactory.getLogger(TemplateEngineProcess.class);
    @Resource
    private IVariableUtil variableUtil;
    @Resource
    private IInputUtil inputUtil;
    @Resource
    protected IOutputUtil outputUtil;
    @Resource
    private IProcessConfUtil processConfUtil;

    public void process(ProcessContent content) throws BizException {
        Configuration cfg = new Configuration();
        String encoding = this.variableUtil.calVarInConf(content, "defaultEncoding");
        Template template = null;
        String templateDataType = content.getStepConfString("templateDataType");
        if ("file".equals(templateDataType)) {
            template = this.getTemplateByPath(content, cfg, encoding);
        } else if ("string".equals(templateDataType)) {
            template = this.getTemplateByStr(content, cfg, encoding);
        } else {
            throw new BizException(ResultCode.CONF_ERROR, "\u8bf7\u9009\u62e9\u662f\u5426\u4f7f\u7528\u6a21\u7248\u6587\u4ef6\uff01");
        }
        Map param = this.inputUtil.getHandleObject(content, "params");
        StringWriter writer = new StringWriter();
        try {
            template.process((Object)param, (Writer)writer);
        }
        catch (Exception e) {
            LOGGER.error("templateProcess error param:\u3010{}\u3011,templateDataType:\u3010{}\u3011, e:\u3010{}\u3011", new Object[]{param, templateDataType, e});
            throw new BizException((Throwable)e);
        }
        String destContent = writer.toString();
        String outPutType = content.getStepConfString("outPutType");
        if ("file".equals(outPutType)) {
            this.generateFile(content, destContent, encoding);
        } else {
            this.outputUtil.setDefaultReturnKey(content, "outputData");
            this.outputUtil.putData(content, (Object)destContent);
        }
    }

    private void generateFile(ProcessContent content, String destContent, String encoding) throws BizException {
        String parent;
        boolean exist;
        this.processConfUtil.checkConf(content, new String[]{"outPutFilePath"});
        String outPutFilePath = this.variableUtil.calVarInConf(content, "outPutFilePath");
        if (StrUtil.isBlank((CharSequence)outPutFilePath)) {
            throw new BizException(ResultCode.CONF_ERROR, "\u8f93\u51fa\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a!");
        }
        String filePathPolicy = content.getStepConfString("filePathPolicy");
        if ("error".equals(filePathPolicy) && !(exist = FileUtil.exist((String)(parent = FileUtil.getParent((String)outPutFilePath, (int)1))))) {
            throw new BizException(ResultCode.CONF_ERROR, "\u6587\u4ef6\u8def\u5f84\u4e0d\u5b58\u5728\uff1a" + parent);
        }
        String duplicateFileNamePolicy = content.getStepConfString("duplicateFileNamePolicy");
        if ("cover".equals(duplicateFileNamePolicy)) {
            FileUtil.writeString((String)destContent, (String)outPutFilePath, (String)encoding);
        } else if ("append".equals(duplicateFileNamePolicy)) {
            FileUtil.appendString((String)destContent, (String)outPutFilePath, (String)encoding);
        } else {
            if (FileUtil.exist((String)outPutFilePath)) {
                throw new BizException(ResultCode.CONF_ERROR, "\u6587\u4ef6\u5df2\u5b58\u5728\uff1a" + outPutFilePath);
            }
            FileUtil.writeString((String)destContent, (String)outPutFilePath, (String)encoding);
        }
        String needDownload = content.getStepConfString("needDownload");
        if ("Y".equals(needDownload)) {
            content.getStepConf().put("returnKey", (Object)"lowcodeFileUrl");
            this.outputUtil.putData(content, (Object)outPutFilePath);
        }
    }

    private Template getTemplateByStr(ProcessContent content, Configuration cfg, String encoding) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"import"});
        String tempDataSubType = content.getStepConfString("tempDataSubType");
        String ftlCode = null;
        if (StringUtils.isNotBlank((CharSequence)tempDataSubType) && StringUtils.equals((CharSequence)tempDataSubType, (CharSequence)"templateDataVar")) {
            Map varMap = this.inputUtil.getHandleObject(content, "import");
            String varKey = content.getStepConfString("import");
            ftlCode = String.valueOf(varMap.get(varKey));
        } else {
            ftlCode = content.getStepConfString("import");
        }
        StringTemplateLoader stringLoader = new StringTemplateLoader();
        ftlCode = ftlCode.trim();
        cfg.setTemplateLoader((TemplateLoader)stringLoader);
        stringLoader.putTemplate("manateeTemplate", ftlCode);
        try {
            Template template = cfg.getTemplate("manateeTemplate", encoding);
            return template;
        }
        catch (IOException e) {
            LOGGER.error("getTemplateByStr error ftlCode:\u3010{}\u3011,e:\u3010{}\u3011", (Object)ftlCode, (Object)e);
            throw new BizException(ResultCode.CONF_ERROR, "\u6a21\u7248\u914d\u7f6e\u9519\u8bef!");
        }
    }

    private Template getTemplateByPath(ProcessContent content, Configuration cfg, String encoding) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"templateDataPath"});
        String templateDataPath = this.variableUtil.calVarInConf(content, "templateDataPath");
        if (StrUtil.isBlank((CharSequence)templateDataPath) || !FileUtil.exist((String)templateDataPath)) {
            throw new BizException(ResultCode.CONF_ERROR, "\u6a21\u7248\u8def\u5f84\u914d\u7f6e\u9519\u8bef\uff01");
        }
        String name = FileUtil.getName((String)templateDataPath);
        String parent = FileUtil.getParent((String)templateDataPath, (int)1);
        try {
            cfg.setTemplateLoader((TemplateLoader)new FileTemplateLoader(FileUtil.file((String)parent)));
            Template template = cfg.getTemplate(name, encoding);
            return template;
        }
        catch (IOException e) {
            LOGGER.error("getTemplateByPath error filePath:\u3010{}\u3011, e:}\u3011", (Object)templateDataPath, (Object)e);
            throw new BizException(ResultCode.CONF_ERROR, "\u6a21\u7248\u8def\u5f84\u914d\u7f6e\u9519\u8bef!:" + templateDataPath);
        }
    }

    public String getName() {
        return "templateEngineProcess";
    }
}

