/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.java.springCompiler;

import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.lowcode.constant.JavaCompilerSo;
import com.manatee.lowcode.java.springCompiler.ManateeJavaFileManager;
import com.manatee.lowcode.java.springCompiler.ManateeSpringJavaFileManager;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.system.ApplicationHome;

public class ManateeClassLoader
extends URLClassLoader {
    private static Logger LOGGER = LoggerFactory.getLogger(ManateeClassLoader.class);
    private Map<String, byte[]> classBytes = new ConcurrentHashMap<String, byte[]>();

    public ManateeClassLoader() {
        super(new URL[0], ManateeClassLoader.class.getClassLoader());
    }

    public static ManateeClassLoader getInstrance() {
        return new ManateeClassLoader();
    }

    public void registerJava(String className, String javaStr, Map<String, Object> errorInfo, byte[] compilerData) throws BizException {
        Map<String, byte[]> compile = this.compile(className, javaStr, errorInfo);
        compilerData = compile.get(className);
        this.classBytes.putAll(compile);
    }

    public void registerJava(JavaCompilerSo javaCompilerSo) throws BizException {
        Map<String, byte[]> compile = this.compile(javaCompilerSo.getPath(), javaCompilerSo.getFormatCode(), javaCompilerSo.getErrorInfo());
        byte[] bytes = compile.get(javaCompilerSo.getPath());
        javaCompilerSo.setCompilerData(bytes);
        this.classBytes.putAll(compile);
    }

    public static ManateeSpringJavaFileManager getStandardFileManager(DiagnosticListener<? super JavaFileObject> diagnostics, Locale locale, Charset charset) {
        Context context = new Context();
        context.put(Locale.class, locale);
        if (diagnostics != null) {
            context.put(DiagnosticListener.class, diagnostics);
        }
        PrintWriter printWriter = charset == null ? new PrintWriter(System.out, true) : new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.err, charset), true);
        context.put(Log.outKey, printWriter);
        return new ManateeSpringJavaFileManager(context, true, charset);
    }

    public Map<String, byte[]> compile(String className, String javaStr, Map<String, Object> errorInfo) throws BizException {
        return this.compile(className, javaStr, errorInfo, false);
    }

    public Map<String, byte[]> compile(String className, String javaStr, Map<String, Object> errorInfo, boolean isLoad) throws BizException {
        JavaFileObject javaFileObject;
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler == null && isLoad) {
            throw new BizException("\u8bf7\u68c0\u67e5\u73af\u5883\u53d8\u91cf JAVA_HOME \u914d\u7f6e\u662f\u5426\u6b63\u786e\u6216\u8005lowcode_compiler \u8868\u6570\u636e\u662f\u5426\u540c\u6b65");
        }
        if (compiler == null) {
            throw new BizException("\u8bf7\u68c0\u67e5\u73af\u5883\u53d8\u91cf JAVA_HOME \u914d\u7f6e\u662f\u5426\u6b63\u786e");
        }
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        ManateeSpringJavaFileManager stdManager = ManateeClassLoader.getStandardFileManager(diagnostics, null, null);
        ManateeJavaFileManager manager = new ManateeJavaFileManager(stdManager);
        JavaCompiler.CompilationTask task = compiler.getTask(null, manager, diagnostics, null, null, Arrays.asList(javaFileObject = manager.makeStringSource(className, javaStr)));
        if (task.call().booleanValue()) {
            return manager.getClassBytes();
        }
        for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
            Diagnostic.Kind kind = diagnostic.getKind();
            if (kind != Diagnostic.Kind.ERROR) continue;
            String error = this.compileError(diagnostic, errorInfo);
            throw new BizException(ResultCode.CONF_ERROR, error);
        }
        throw new BizException("compile error");
    }

    public Class loadClass(String fullName, byte[] javaClassObject) {
        return this.defineClass(fullName, javaClassObject, 0, javaClassObject.length);
    }

    public Class<?> getClass(String name) throws ClassNotFoundException {
        return this.findClass(name);
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] buf = this.classBytes.get(name);
        if (buf == null) {
            return super.findClass(name);
        }
        this.classBytes.remove(name);
        return this.defineClass(name, buf, 0, buf.length);
    }

    public Class<?> findClass(String name, byte[] buf) {
        this.classBytes.remove(name);
        return this.defineClass(name, buf, 0, buf.length);
    }

    public static String getPath() {
        ApplicationHome home = new ApplicationHome(ManateeJavaFileManager.class);
        String path = home.getSource().getPath();
        return path;
    }

    public static boolean isJar() {
        return ManateeClassLoader.getPath().endsWith(".jar");
    }

    private String compileError(Diagnostic diagnostic, Map<String, Object> errorInfo) {
        LOGGER.error(diagnostic.toString());
        StringBuilder res = new StringBuilder();
        String message = diagnostic.getMessage(null);
        int i = message.indexOf("\u4f4d\u7f6e:");
        if (i != -1) {
            message = message.substring(0, i);
        }
        message = message.replaceAll("\\n", "");
        res.append("LineNumber:[").append(diagnostic.getLineNumber()).append("];");
        res.append("Message:[").append(message).append("]\n");
        if (errorInfo != null) {
            errorInfo.put("LineNumber", diagnostic.getLineNumber());
            errorInfo.put("Message", message);
        }
        return res.toString();
    }
}

