/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.quartz.util;

import com.alibaba.fastjson.JSONObject;
import com.manatee.manager.SpringContextManager;
import com.manatee.quartz.domain.QuartzJob;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class JobInvokeUtil {
    public static Object invokeMethod(QuartzJob job) throws Exception {
        String beanName = "modularityQuartzJob";
        String methodName = "modularityJobHandler";
        List<Object[]> methodParams = JobInvokeUtil.getMethodParams(job);
        if (!JobInvokeUtil.isValidClassName(beanName)) {
            Object bean = SpringContextManager.getBean((String)beanName);
            return JobInvokeUtil.invokeMethod(bean, methodName, methodParams);
        }
        Object bean = Class.forName(beanName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        return JobInvokeUtil.invokeMethod(bean, methodName, methodParams);
    }

    public static Object callbackInvokeMethod(QuartzJob job) throws Exception {
        String beanName = "modularityQuartzJob";
        String methodName = "modularityJobHandler";
        List<Object[]> methodParams = JobInvokeUtil.getCallbackMethodParams(job);
        if (!JobInvokeUtil.isValidClassName(beanName)) {
            Object bean = SpringContextManager.getBean((String)beanName);
            return JobInvokeUtil.invokeMethod(bean, methodName, methodParams);
        }
        Object bean = Class.forName(beanName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        return JobInvokeUtil.invokeMethod(bean, methodName, methodParams);
    }

    private static Object invokeMethod(Object bean, String methodName, List<Object[]> methodParams) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (null != methodParams && methodParams.size() > 0) {
            Method method = bean.getClass().getMethod(methodName, JobInvokeUtil.getMethodParamsType(methodParams));
            return method.invoke(bean, JobInvokeUtil.getMethodParamsValue(methodParams));
        }
        Method method = bean.getClass().getMethod(methodName, new Class[0]);
        return method.invoke(bean, new Object[0]);
    }

    public static boolean isValidClassName(String invokeTarget) {
        return StringUtils.countMatches((CharSequence)invokeTarget, (CharSequence)".") > 1;
    }

    public static List<Object[]> getMethodParams(QuartzJob job) {
        LinkedList<Object[]> classs = new LinkedList<Object[]>();
        classs.add(new Object[]{job.getProjectId(), Long.class});
        classs.add(new Object[]{job.getJobModuleCode(), String.class});
        classs.add(new Object[]{job.getJobParams() != null ? JSONObject.parseObject((String)job.getJobParams()) : null, Map.class});
        return classs;
    }

    public static List<Object[]> getCallbackMethodParams(QuartzJob job) {
        LinkedList<Object[]> classs = new LinkedList<Object[]>();
        classs.add(new Object[]{job.getProjectId(), Long.class});
        classs.add(new Object[]{job.getCallbackModuleCode(), String.class});
        classs.add(new Object[]{job.getCallbackParams() != null ? JSONObject.parseObject((String)job.getCallbackParams()) : null, Map.class});
        return classs;
    }

    public static Class<?>[] getMethodParamsType(List<Object[]> methodParams) {
        Class[] classs = new Class[methodParams.size()];
        int index = 0;
        for (Object[] os : methodParams) {
            classs[index] = (Class)os[1];
            ++index;
        }
        return classs;
    }

    public static Object[] getMethodParamsValue(List<Object[]> methodParams) {
        Object[] classs = new Object[methodParams.size()];
        int index = 0;
        for (Object[] os : methodParams) {
            classs[index] = os[0];
            ++index;
        }
        return classs;
    }
}

