/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.pdf.process;

import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.lowcode.util.GlobalConf;
import com.manatee.pdf.util.ExcelToPdfUtil;
import com.manatee.pdf.util.PptToPdfUtil;
import com.manatee.pdf.util.WordToPdfUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class FileToPdfProcess
implements IProcess {
    @Resource
    private IOutputUtil outputUtil;
    @Resource
    private IVariableUtil variableUtil;

    public void process(ProcessContent content) throws BizException {
        String fileName;
        InputStream inputStream;
        String fileType = this.variableUtil.calVarInConf(content, "fileType");
        String localFilePath = this.variableUtil.calVarInConf(content, "localFilePath");
        String fileWatermark = this.variableUtil.calVarInConf(content, "fileWatermark");
        Boolean needDel = content.getStepConf().getBoolean("needDel");
        File file = null;
        if (localFilePath != null) {
            file = new File(localFilePath);
            try {
                inputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                throw new BizException(ResultCode.PARAM_IS_ERROR, "file not found", (Throwable)e);
            }
            fileName = file.getName();
        } else {
            inputStream = content.getFile();
            fileName = content.getFileName();
        }
        String suffixName = this.getFileSuffixUsingSubstring(fileName);
        if (StringUtils.isEmpty((CharSequence)suffixName)) {
            BizException bizException = new BizException(ResultCode.BIZ_ERROR);
            bizException.setMsg("\u65e0\u6cd5\u786e\u5b9a\u6587\u4ef6\u540e\u7f00");
            throw bizException;
        }
        boolean typeError = false;
        if (StringUtil.equals((CharSequence)fileType, (CharSequence)"excel")) {
            if (!StringUtils.equals((CharSequence)suffixName, (CharSequence)"xls") && !StringUtils.equals((CharSequence)suffixName, (CharSequence)"xlsx")) {
                typeError = true;
            }
        } else if (StringUtil.equals((CharSequence)fileType, (CharSequence)"word")) {
            if (!StringUtils.equals((CharSequence)suffixName, (CharSequence)"doc") && !StringUtils.equals((CharSequence)suffixName, (CharSequence)"docx")) {
                typeError = true;
            }
        } else if (StringUtil.equals((CharSequence)fileType, (CharSequence)"ppt") && !StringUtils.equals((CharSequence)suffixName, (CharSequence)"ppt") && !StringUtils.equals((CharSequence)suffixName, (CharSequence)"pptx")) {
            typeError = true;
        }
        if (typeError) {
            BizException bizException = new BizException(ResultCode.BIZ_ERROR);
            bizException.setMsg("\u6587\u4ef6(." + suffixName + ")\u4e0e\u6240\u9009\u7c7b\u578b(" + fileType + ")\u4e0d\u5339\u914d");
            throw bizException;
        }
        String pdfName = this.variableUtil.calVarInConf(content, "pdfName");
        if (!pdfName.endsWith(".pdf")) {
            pdfName = pdfName + ".pdf";
        }
        String pdfPath = GlobalConf.TEMP_DIRECTORY + pdfName;
        try {
            OutputStream outputStream;
            if (StringUtil.equals((CharSequence)fileType, (CharSequence)"excel")) {
                outputStream = Files.newOutputStream(Paths.get(pdfPath, new String[0]), new OpenOption[0]);
                ExcelToPdfUtil.excelToPdf(inputStream, outputStream, fileWatermark);
            } else if (StringUtil.equals((CharSequence)fileType, (CharSequence)"word")) {
                outputStream = Files.newOutputStream(Paths.get(pdfPath, new String[0]), new OpenOption[0]);
                if (StringUtils.equals((CharSequence)suffixName, (CharSequence)"docx")) {
                    WordToPdfUtil.docxHtmlToPdf(inputStream, outputStream, fileWatermark);
                } else if (StringUtils.equals((CharSequence)suffixName, (CharSequence)"doc")) {
                    WordToPdfUtil.docToPdf(inputStream, outputStream, fileWatermark);
                }
            } else if (StringUtil.equals((CharSequence)fileType, (CharSequence)"ppt")) {
                outputStream = Files.newOutputStream(Paths.get(pdfPath, new String[0]), new OpenOption[0]);
                if (StringUtils.equals((CharSequence)suffixName, (CharSequence)"pptx")) {
                    PptToPdfUtil.pptxToPdf(inputStream, outputStream, fileWatermark);
                } else if (StringUtils.equals((CharSequence)suffixName, (CharSequence)"ppt")) {
                    PptToPdfUtil.pptToPdf(inputStream, outputStream, fileWatermark);
                }
            }
        }
        catch (Exception e) {
            BizException bizException = new BizException(ResultCode.BIZ_ERROR, (Throwable)e);
            bizException.setMsg("\u6587\u4ef6\u8f6cPDF\u5931\u8d25");
            throw bizException;
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (needDel != null && file != null && needDel.booleanValue() && file.exists()) {
            file.delete();
        }
        content.getStepConf().put("returnKey", (Object)"lowcodeTempFileUrl");
        this.outputUtil.putData(content, (Object)pdfPath);
    }

    private String getFileSuffixUsingSubstring(String fileName) {
        if (fileName.lastIndexOf(".") != -1 && fileName.lastIndexOf(".") != 0) {
            return fileName.substring(fileName.lastIndexOf(".") + 1);
        }
        return "";
    }

    public String getName() {
        return "fileToPdfProcess";
    }
}

