/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.generation.service;

import com.alibaba.fastjson.JSON;
import com.aliyun.oss.ServiceException;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.DateUtils;
import com.manatee.common.util.StringUtil;
import com.manatee.common.util.tool.core.collection.CollUtil;
import com.manatee.lowcode.generation.constant.GenerationConstant;
import com.manatee.lowcode.generation.domain.GenerationProcessContentBuilder;
import com.manatee.lowcode.generation.entity.GenerateDTO;
import com.manatee.lowcode.generation.entity.ModuleDTO;
import com.manatee.lowcode.generation.entity.PackageDTO;
import com.manatee.lowcode.generation.factory.GenerationProcessContentBuilderFactory;
import com.manatee.lowcode.generation.template.BaseProcessTemplate;
import com.manatee.lowcode.generation.template.base.BaseTemplate;
import com.manatee.lowcode.generation.util.PinyinUtil;
import com.manatee.lowcode.generation.util.TemplateUtils;
import com.manatee.lowcode.util.GlobalConf;
import com.manatee.manager.SpringContextManager;
import com.manatee.process.ProcessDataSource;
import com.manatee.process.domain.Step;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Service;

@Service
public class GenerationService {
    private static final Logger log = LoggerFactory.getLogger(GenerationService.class);
    private Configuration configuration = new Configuration(Configuration.VERSION_2_3_23);

    public boolean checkIntroduceGeneration() {
        return true;
    }

    public String generateProjectSource(GenerateDTO dto) throws BizException {
        String generationTemp = "generationTemp";
        String projectName = dto.getProjectName();
        String newProjectPathStr = GlobalConf.TEMP_DIRECTORY;
        this.copyDemoProject();
        String packageName = dto.getPackageName();
        String projectDescribe = dto.getProjectDescribe();
        String applicationFileName = "ProjectApplication";
        String sourceRootPath = newProjectPathStr + generationTemp + "/" + projectName + "/src/main/java/";
        String resourcesRootPath = newProjectPathStr + generationTemp + "/" + projectName + "/src/main/resources/";
        String packageRootPath = sourceRootPath + packageName.replace(".", "/") + "/";
        String controllerDir = packageRootPath + "controller";
        File controllerFile = new File(controllerDir);
        controllerFile.mkdirs();
        String serviceDir = packageRootPath + "service";
        File serviceFile = new File(serviceDir);
        serviceFile.mkdirs();
        String serviceImplDir = packageRootPath + "service/impl";
        File implFile = new File(serviceImplDir);
        implFile.mkdirs();
        String confDir = packageRootPath + "conf";
        File confFile = new File(confDir);
        confFile.mkdirs();
        String confJsonDir = resourcesRootPath + "confJson";
        File confJsonFile = new File(confJsonDir);
        confJsonFile.mkdirs();
        HashMap<String, Object> baseMap = new HashMap<String, Object>();
        baseMap.putAll(GenerationConstant.STATIC_MAP);
        baseMap.put("package", packageName);
        baseMap.put("scanPackageManatee", "com.manatee");
        baseMap.put("scanPackageCustom", packageName.substring(0, packageName.lastIndexOf(".")));
        baseMap.put("projectName", projectName);
        baseMap.put("projectDescribe", projectDescribe);
        baseMap.put("applicationClassName", applicationFileName);
        baseMap.put("projectConfStr", JSONObject.valueToString((Object)dto.getProjectConf().toJSONString()));
        this.generateByTemplate(baseMap, "ProjectApplication.java.ftl", packageRootPath + applicationFileName + ".java");
        this.generateProjectConfByTemplate(baseMap, packageRootPath + "conf/ProjectConf.java");
        List<PackageDTO> packageList = dto.getPackageList();
        this.generationByCodeType(packageList, baseMap, packageRootPath, packageName, confJsonDir);
        String fromPath = newProjectPathStr + generationTemp + "/" + projectName;
        this.compress(fromPath, fromPath + ".zip");
        byte[] bytes = this.file2Byte(fromPath + ".zip");
        return Base64.getEncoder().encodeToString(bytes);
    }

    private void copyDemoProject() {
        String generationTemp = "generationTemp";
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            Resource[] resources;
            ClassPathResource projectTemplateResource = new ClassPathResource("manatee-project-source");
            String projectPathStr = projectTemplateResource.getURL().getPath();
            String newProjectPathStr = GlobalConf.TEMP_DIRECTORY + generationTemp + "/manatee-source-demo";
            for (Resource resource : resources = resolver.getResources("manatee-project-source/**/*")) {
                String pathStr = resource.getURL().getPath();
                String newPathStr = pathStr.replace(projectPathStr, newProjectPathStr);
                InputStream stream = resource.getInputStream();
                boolean isPath = false;
                if (newPathStr.endsWith("/")) {
                    newPathStr = newPathStr.substring(0, newPathStr.length() - 1);
                    isPath = true;
                }
                File file = GenerationService.write2File(stream, newPathStr, isPath);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    private void generationByCodeType(List<PackageDTO> packageList, Map<String, Object> baseMap, String packageRootPath, String packageName, String confJsonPath) throws BizException {
        if (packageList != null && packageList.size() > 0) {
            TemplateUtils templateUtils = (TemplateUtils)SpringContextManager.getBean(TemplateUtils.class);
            for (PackageDTO packageDTO : packageList) {
                if (packageDTO.isModule().booleanValue() || !StringUtils.isNotEmpty((CharSequence)packageDTO.getTitle()) || CollUtil.isEmpty(packageDTO.getChildren())) continue;
                String className = PinyinUtil.getPingYin(packageDTO.getTitle());
                String upClassName = StringUtils.capitalize((String)className);
                baseMap.put("moduleName", packageDTO.getTitle());
                baseMap.put("upClassName", upClassName);
                baseMap.put("className", className);
                baseMap.put("date", DateUtils.formatDateTime((Date)new Date()));
                List<ModuleDTO> moduleList = this.getModuleList(packageDTO);
                if (CollUtil.isEmpty(moduleList)) continue;
                baseMap.put("moduleList", moduleList);
                this.generateControllerByTemplate(baseMap, packageRootPath + "controller/" + upClassName + "Controller.java");
                this.generateServiceByTemplate(baseMap, packageRootPath + "service/" + upClassName + "Service.java");
                this.creatServiceImpl(packageName, packageRootPath, templateUtils, upClassName, moduleList, confJsonPath);
            }
        }
    }

    private static File write2File(InputStream is, String filePath, boolean isPath) {
        File file = new File(filePath);
        try {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if (!file.exists()) {
                if (isPath) {
                    file.mkdirs();
                    return file;
                }
                file.createNewFile();
            } else if (isPath) {
                return file;
            }
        }
        catch (IOException e) {
            log.info("\u521b\u5efa\u6587\u4ef6" + filePath + "\u5931\u8d25\uff01" + e.getMessage());
        }
        try {
            FileOutputStream os = new FileOutputStream(file);
            int len = 8192;
            byte[] buffer = new byte[len];
            while ((len = is.read(buffer, 0, len)) != -1) {
                ((OutputStream)os).write(buffer, 0, len);
            }
            ((OutputStream)os).close();
            is.close();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return file;
    }

    private String generateByTemplate(Map<String, Object> objectMap, String templateName, String toPath) {
        try {
            this.configuration.setClassForTemplateLoading(this.getClass(), "/template");
            this.configuration.setNumberFormat("#");
            Template template = this.configuration.getTemplate(templateName);
            File toFile = new File(toPath);
            if (!toFile.exists()) {
                toFile.createNewFile();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(toFile);
            template.process(objectMap, (Writer)new OutputStreamWriter((OutputStream)fileOutputStream, Charset.forName("UTF-8").name()));
            fileOutputStream.close();
            log.info("\u6587\u4ef6[" + toPath + "]\u521b\u5efa\u6210\u529f");
            return toFile.getPath();
        }
        catch (Exception e) {
            log.error("generateByTemplate error ,templateName:\u3010{}\u3011, toPath:\u3010{}\u3011, objectMap:\u3010{}\u3011,e:{}", new Object[]{templateName, toPath, objectMap, e});
            return null;
        }
    }

    private void creatServiceImpl(String packageName, String packageRootPath, TemplateUtils templateUtils, String upClassName, List<ModuleDTO> moduleList, String confJsonPath) throws BizException {
        GenerationProcessContentBuilder codeBuilder = GenerationProcessContentBuilderFactory.creat(upClassName, packageName);
        HashMap<String, ModuleDTO> moduleCodeMap = new HashMap<String, ModuleDTO>();
        for (ModuleDTO moduleDTO : moduleList) {
            moduleCodeMap.put(moduleDTO.getModuleCode(), moduleDTO);
        }
        codeBuilder.setModuleCodeMap(moduleCodeMap);
        for (ModuleDTO moduleDTO : moduleList) {
            String processConf = moduleDTO.getProcessConf();
            String moduleCode = moduleDTO.getModuleCode();
            codeBuilder.setCurrentFunName(moduleCode);
            codeBuilder.addCode(new StringBuilder());
            codeBuilder.setPackageId(moduleDTO.getPackageId());
            List steps = ProcessDataSource.formatSteps((com.alibaba.fastjson.JSONObject)JSON.parseObject((String)processConf));
            for (Step step : steps) {
                String name = step.getName();
                BaseTemplate template = templateUtils.getTemplate(name);
                if (StringUtil.equals((CharSequence)template.getName(), (CharSequence)"baseProcessTemplate")) {
                    BaseProcessTemplate baseProcessTemplate = (BaseProcessTemplate)template;
                    baseProcessTemplate.setStepConfJsonPath(confJsonPath);
                    baseProcessTemplate.bulid(codeBuilder, step);
                    continue;
                }
                template.bulid(codeBuilder, step);
            }
        }
        codeBuilder.setToPath(packageRootPath + "service/impl/" + upClassName + "ServiceImpl.java");
        codeBuilder.build();
    }

    public String generateControllerByTemplate(Map<String, Object> objectMap, String toFilePath) {
        return this.generateByTemplate(objectMap, "java/Controller.java.ftl", toFilePath);
    }

    public String generateServiceByTemplate(Map<String, Object> objectMap, String toFilePath) {
        return this.generateByTemplate(objectMap, "java/Service.java.ftl", toFilePath);
    }

    public String generateProjectConfByTemplate(Map<String, Object> objectMap, String toFilePath) {
        return this.generateByTemplate(objectMap, "java/ProjectConf.java.ftl", toFilePath);
    }

    private List<ModuleDTO> getModuleList(PackageDTO data) {
        ArrayList<ModuleDTO> moduleList = new ArrayList<ModuleDTO>();
        if (data.isModule().booleanValue()) {
            moduleList.add(data.getModule());
        }
        if (!data.isLeaf().booleanValue() && CollUtil.isNotEmpty(data.getChildren())) {
            for (PackageDTO child : data.getChildren()) {
                moduleList.addAll(this.getModuleList(child));
            }
        }
        return moduleList;
    }

    private void compress(String fromPath, String toPath) {
        File fromFile = new File(fromPath);
        File toFile = new File(toPath);
        if (!fromFile.exists()) {
            throw new ServiceException(fromPath + "\u4e0d\u5b58\u5728\uff01");
        }
        try (FileOutputStream outputStream = new FileOutputStream(toFile);
             CheckedOutputStream checkedOutputStream = new CheckedOutputStream(outputStream, new CRC32());
             ZipOutputStream zipOutputStream = new ZipOutputStream(checkedOutputStream);){
            String baseDir = "";
            this.compress(fromFile, zipOutputStream, baseDir);
            this.deleteFolder(fromFile);
        }
        catch (Exception e) {
            log.error("\u538b\u7f29\u6587\u4ef6\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    private void compress(File file, ZipOutputStream zipOut, String baseDir) throws IOException {
        if (file.isDirectory()) {
            this.compressDirectory(file, zipOut, baseDir);
        } else {
            this.compressFile(file, zipOut, baseDir);
        }
    }

    private void compressFile(File file, ZipOutputStream zipOut, String baseDir) throws IOException {
        if (!file.exists()) {
            return;
        }
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));){
            int count;
            ZipEntry entry = new ZipEntry(baseDir + file.getName());
            zipOut.putNextEntry(entry);
            byte[] data = new byte[1024];
            while ((count = bis.read(data, 0, 1024)) != -1) {
                zipOut.write(data, 0, count);
            }
        }
        catch (Exception e) {
            log.error("\u5199\u538b\u7f29\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
        }
    }

    private void compressDirectory(File dir, ZipOutputStream zipOut, String baseDir) throws IOException {
        Object[] files = dir.listFiles();
        if (files != null && ArrayUtils.isNotEmpty((Object[])files)) {
            for (Object file : files) {
                this.compress((File)file, zipOut, baseDir + dir.getName() + File.separator);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] file2Byte(String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            return null;
        }
        byte[] zipData = null;
        FileInputStream fis = null;
        try {
            zipData = new byte[(int)file.length()];
            fis = new FileInputStream(file);
            fis.read(zipData);
        }
        catch (Exception e) {
            log.error("\u8bfb\u53d6\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    log.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        file.delete();
        return zipData;
    }

    private void deleteFolder(File folder) {
        File[] fileList = folder.listFiles();
        if (fileList != null) {
            for (File file : fileList) {
                if (file.isDirectory()) {
                    this.deleteFolder(file);
                    continue;
                }
                file.delete();
            }
        }
        folder.delete();
    }

    public static void main(String[] args) {
    }
}

