/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.sqlserver.store;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.DBQuery;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.CloneUtil;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.lowcodedb.base.DBReadUtil;
import com.manatee.lowcodedb.manager.DBManager;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SqlserverQueryOneProcess
implements IProcess {
    @Resource
    protected IOutputUtil outputUtil;
    @Resource
    private DBManager dBManager;
    @Resource
    private ProcessConfUtil processConfUtil;
    @Resource
    private DBReadUtil dbReadUtil;
    @Resource
    private VariableUtil variableUtil;

    public void process(ProcessContent content) throws BizException {
        JSONObject totalCountJson;
        JSON data;
        this.processConfUtil.checkConf(content, new String[]{"table"});
        DBQuery dbQuery = this.dBManager.getDBQuery(content, "microsoft sql server");
        DBQuery dbQueryForCount = (DBQuery)CloneUtil.cloneByStream((Object)dbQuery);
        try {
            data = this.queryData(dbQuery);
        }
        catch (BizException e) {
            throw e;
        }
        finally {
            this.dBManager.logExecuteSql(content, dbQuery.getExecuteSql());
        }
        data = this.cascadeQuery(dbQuery, data);
        if (data != null) {
            this.outputUtil.handleAndPutData(content, (Object)data);
        }
        if ((totalCountJson = this.queryTotalCount(dbQueryForCount, content)) != null) {
            this.outputUtil.unfoldPutData(content, (Map)totalCountJson);
        }
    }

    public JSON queryData(DBQuery dbQuery) throws BizException {
        JSON data = this.dbReadUtil.find(dbQuery);
        return data;
    }

    public JSON cascadeQuery(DBQuery dbQuery, JSON data) throws BizException {
        JSONArray cascadeArray = dbQuery.getCascade();
        if (cascadeArray == null || cascadeArray.size() == 0) {
            return data;
        }
        if (data == null) {
            return data;
        }
        if (data instanceof List || data instanceof JSONArray) {
            JSONArray dataArray = (JSONArray)data;
            if (dataArray.size() == 0) {
                return data;
            }
            Boolean camelCase = dbQuery.getCamelCase();
            String upperOrLowerCase = dbQuery.getUpperOrLowerCase();
            for (Object cascadeConfObj : cascadeArray) {
                JSONObject cascadeConf = (JSONObject)cascadeConfObj;
                String cascadeKey = cascadeConf.getString("cascadeKey");
                cascadeKey = this.getCascadeKey(camelCase, upperOrLowerCase, cascadeKey);
                String beCascadeedKey = cascadeConf.getString("beCascadeedKey");
                ArrayList cascade = this.dbReadUtil.findCascade(dbQuery, data, cascadeConf);
                if (cascade == null) {
                    cascade = new ArrayList();
                }
                beCascadeedKey = this.getCascadeKey(camelCase, upperOrLowerCase, beCascadeedKey);
                HashMap groupByMap = new HashMap();
                for (Map resuletMap : cascade) {
                    Object o = resuletMap.get(beCascadeedKey);
                    ArrayList<Map> list = (ArrayList<Map>)groupByMap.get(o);
                    if (list == null) {
                        list = new ArrayList<Map>();
                    }
                    list.add(resuletMap);
                    groupByMap.put(o, list);
                }
                String cascadeVal = cascadeConf.getString("cascadeVal");
                for (Object o : dataArray) {
                    Map dataItem = (Map)o;
                    Object cascadeKeyObj = dataItem.get(cascadeKey);
                    Object cascadeGroup = groupByMap.get(cascadeKeyObj);
                    if (StringUtil.isBlank((String)cascadeVal)) {
                        String table = cascadeConf.getString("table") + "_list";
                        cascadeVal = this.dbReadUtil.camelCase(table.toLowerCase());
                    }
                    if (cascadeGroup == null) {
                        cascadeGroup = new ArrayList();
                    }
                    dataItem.put(cascadeVal, cascadeGroup);
                }
            }
        } else {
            JSONObject result = (JSONObject)data;
            for (Object cascadeConfObj : cascadeArray) {
                JSONObject cascadeConf = (JSONObject)cascadeConfObj;
                List cascade = this.dbReadUtil.findCascade(dbQuery, data, cascadeConf);
                String cascadeVal = cascadeConf.getString("cascadeVal");
                if (StringUtil.isBlank((String)cascadeVal)) {
                    String table = cascadeConf.getString("table") + "_list";
                    cascadeVal = this.dbReadUtil.camelCase(table.toLowerCase());
                }
                result.put(cascadeVal, (Object)cascade);
            }
        }
        return data;
    }

    private String getCascadeKey(Boolean camelCase, String upperOrLowerCase, String fieldName) {
        if (StringUtil.isNotBlank((String)upperOrLowerCase) && "upperCase".equals(upperOrLowerCase)) {
            fieldName = fieldName.toUpperCase();
        }
        if (StringUtil.isNotBlank((String)upperOrLowerCase) && "lowerCase".equals(upperOrLowerCase)) {
            fieldName = fieldName.toLowerCase();
        }
        if (camelCase.booleanValue() && fieldName.indexOf("_") != -1) {
            fieldName = this.dbReadUtil.camelCase(fieldName.toLowerCase());
            return fieldName;
        }
        return fieldName;
    }

    public JSONObject queryTotalCount(DBQuery dbQuery, ProcessContent content) throws BizException {
        if (!dbQuery.getSelectTotalCount().booleanValue() || dbQuery.getPage() == null) {
            return null;
        }
        JSONObject totalCountJson = new JSONObject();
        String totalCountReturnKey = this.variableUtil.calVarInConf(content, "totalCountReturnKey");
        totalCountReturnKey = StringUtil.isBlank((String)totalCountReturnKey) ? "totalCount" : totalCountReturnKey;
        String totalPageReturnKey = this.variableUtil.calVarInConf(content, "totalPageReturnKey");
        totalPageReturnKey = StringUtil.isBlank((String)totalPageReturnKey) ? "totalPage" : totalPageReturnKey;
        Integer totalCount = this.dbReadUtil.findCount(dbQuery);
        if (totalCount != null) {
            totalCountJson.put(totalCountReturnKey, (Object)totalCount);
            Integer pageSize = dbQuery.getPage().getPageSize();
            if (pageSize != null && pageSize > 0) {
                Integer totalPage = totalCount / pageSize;
                if (totalPage * pageSize < totalCount) {
                    Integer n = totalPage;
                    Integer n2 = totalPage = Integer.valueOf(totalPage + 1);
                }
                totalCountJson.put(totalPageReturnKey, (Object)totalPage);
            }
        }
        return totalCountJson;
    }

    public String getName() {
        return "sqlServerQueryOne";
    }
}

