/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.pdf.util;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.Font;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.InputStream;
import org.apache.poi.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class TextWaterMark
extends PdfPageEventHelper {
    private static final Logger log = LoggerFactory.getLogger(TextWaterMark.class);
    private String waterMarkText;

    public TextWaterMark(String waterMarkText) {
        this.waterMarkText = waterMarkText;
    }

    public void onEndPage(PdfWriter writer, Document document) {
        try {
            float pageWidth = document.right() + document.left();
            float pageHeight = document.top() + document.bottom();
            ClassPathResource resource = new ClassPathResource("font/msyh.ttf");
            InputStream inputStream = resource.getInputStream();
            byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
            BaseFont baseFont = BaseFont.createFont((String)"msyh.ttf", (String)"Identity-H", (boolean)true, (boolean)true, (byte[])bytes, null);
            Font waterMarkFont = new Font(baseFont, 10.0f, 1, BaseColor.LIGHT_GRAY);
            PdfContentByte waterMarkPdfContent = writer.getDirectContentUnder();
            Phrase phrase = new Phrase(this.waterMarkText, waterMarkFont);
            ColumnText.showTextAligned((PdfContentByte)waterMarkPdfContent, (int)1, (Phrase)phrase, (float)(pageWidth * 0.2f), (float)(pageHeight * 0.2f), (float)45.0f);
            ColumnText.showTextAligned((PdfContentByte)waterMarkPdfContent, (int)1, (Phrase)phrase, (float)(pageWidth * 0.2f), (float)(pageHeight * 0.5f), (float)45.0f);
            ColumnText.showTextAligned((PdfContentByte)waterMarkPdfContent, (int)1, (Phrase)phrase, (float)(pageWidth * 0.2f), (float)(pageHeight * 0.8f), (float)45.0f);
            ColumnText.showTextAligned((PdfContentByte)waterMarkPdfContent, (int)1, (Phrase)phrase, (float)(pageWidth * 0.5f), (float)(pageHeight * 0.2f), (float)45.0f);
            ColumnText.showTextAligned((PdfContentByte)waterMarkPdfContent, (int)1, (Phrase)phrase, (float)(pageWidth * 0.5f), (float)(pageHeight * 0.5f), (float)45.0f);
            ColumnText.showTextAligned((PdfContentByte)waterMarkPdfContent, (int)1, (Phrase)phrase, (float)(pageWidth * 0.5f), (float)(pageHeight * 0.8f), (float)45.0f);
            ColumnText.showTextAligned((PdfContentByte)waterMarkPdfContent, (int)1, (Phrase)phrase, (float)(pageWidth * 0.8f), (float)(pageHeight * 0.2f), (float)45.0f);
            ColumnText.showTextAligned((PdfContentByte)waterMarkPdfContent, (int)1, (Phrase)phrase, (float)(pageWidth * 0.8f), (float)(pageHeight * 0.5f), (float)45.0f);
            ColumnText.showTextAligned((PdfContentByte)waterMarkPdfContent, (int)1, (Phrase)phrase, (float)(pageWidth * 0.8f), (float)(pageHeight * 0.8f), (float)45.0f);
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception e) {
                log.error("\u5b57\u4f53\u6d41\u5173\u95ed\u5931\u8d25", (Throwable)e);
            }
        }
        catch (Exception e) {
            log.error("pdf\u52a0\u6c34\u5370\u5f02\u5e38", (Throwable)e);
        }
    }
}

