/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.quartz;

import com.manatee.common.domain.DBQuery;
import com.manatee.common.exception.BizException;
import com.manatee.lowcode.baseModule.manager.BaseModuleUtil;
import com.manatee.lowcodedb.base.DBReadUtil;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class InitQuartzJobTable {
    private static final Logger log = LoggerFactory.getLogger(InitQuartzJobTable.class);
    @Value(value="${default-database-product-name:mysql}")
    private String defaultDatabaseProductName;
    @Autowired
    private BaseModuleUtil baseModuleUtil;
    @Autowired
    private DBReadUtil dbReadUtil;

    @PostConstruct
    public void initBaseTable() {
        String lowcodeQuartzJob = "lowcode_quartz_job";
        String lowcodeQuartzJobLog = "lowcode_quartz_job_log";
        String lowcodeQuartzGroup = "lowcode_quartz_group";
        if (this.defaultDatabaseProductName.equals("dameng") || this.defaultDatabaseProductName.equals("oracle")) {
            lowcodeQuartzJob = "LOWCODE_QUARTZ_JOB";
            lowcodeQuartzJobLog = "LOWCODE_QUARTZ_JOB_LOG";
            lowcodeQuartzGroup = "LOWCODE_QUARTZ_GROUP";
        }
        if (!this.baseModuleUtil.isExistTable(lowcodeQuartzJob)) {
            this.baseModuleUtil.initBaseTable("lowcode_quartz_job");
        } else {
            String runStatusKey = "run_status";
            String executeTimeKey = "execute_time";
            String failIsStop = "fail_is_stop";
            if (this.defaultDatabaseProductName.equals("dameng") || this.defaultDatabaseProductName.equals("oracle")) {
                runStatusKey = "RUN_STATUS";
                executeTimeKey = "EXECUTE_TIME";
                failIsStop = "FAIL_IS_STOP";
            }
            if (!this.isExistFiled(lowcodeQuartzJob, runStatusKey)) {
                this.executeSqlScript("lowcode_quartz_job", "1.10.1");
            }
            if (!this.isExistFiled(lowcodeQuartzJob, executeTimeKey)) {
                this.executeSqlScript("lowcode_quartz_job", "1.11.3");
            }
            if (!this.isExistFiled(lowcodeQuartzJob, failIsStop)) {
                this.executeSqlScript("lowcode_quartz_job", "5.4.2.1");
            }
        }
        if (!this.baseModuleUtil.isExistTable(lowcodeQuartzJobLog)) {
            this.baseModuleUtil.initBaseTable("lowcode_quartz_job_log");
        } else {
            String executeType = "execute_type";
            if (this.defaultDatabaseProductName.equals("dameng") || this.defaultDatabaseProductName.equals("oracle")) {
                executeType = "EXECUTE_TYPE";
            }
            if (!this.isExistFiled(lowcodeQuartzJobLog, executeType)) {
                this.executeSqlScript("lowcode_quartz_job", "1.11.1");
            }
        }
        if (!this.baseModuleUtil.isExistTable(lowcodeQuartzGroup)) {
            this.baseModuleUtil.initBaseTable("lowcode_quartz_group");
        }
    }

    private boolean isExistFiled(String table, String filed) {
        String id = "id";
        if (this.defaultDatabaseProductName.equals("dameng")) {
            table = "\"" + table + "\"";
            id = "ID";
        }
        String sql = "select " + filed + " from " + table + " where " + id + " = 0";
        try {
            DBQuery dbQuery = new DBQuery();
            dbQuery.setDatabaseProductName(this.defaultDatabaseProductName);
            dbQuery.setDb("default");
            dbQuery.setSelectOne(Boolean.valueOf(true));
            dbQuery.setSql(sql);
            this.dbReadUtil.executeSelectSql(dbQuery, null);
            return true;
        }
        catch (BizException e) {
            return false;
        }
    }

    private void executeSqlScript(String table, String version) {
        DBQuery dbQuery = new DBQuery();
        dbQuery.setDatabaseProductName(this.defaultDatabaseProductName);
        String initSql = BaseModuleUtil.parseFile((String)("initTableFiles/" + table + "/update/" + this.defaultDatabaseProductName + "_" + version + ".sql"));
        if (initSql != null && initSql.contains(";")) {
            String[] initSqlArray = initSql.split(";");
            try {
                for (String sql : initSqlArray) {
                    log.debug(sql);
                    dbQuery.setSql(sql);
                    this.dbReadUtil.executeNotSelectStatementSql(dbQuery, null);
                }
            }
            catch (BizException e) {
                log.error("\u53d8\u66f4\u57fa\u7840\u5e94\u7528\u8868\u3010{}\u3011\u5931\u8d25,\u8bf7\u624b\u52a8\u6267\u884c", (Object)table);
            }
        } else {
            dbQuery.setSql(initSql);
            try {
                this.dbReadUtil.executeNotSelectSql(dbQuery, null);
            }
            catch (BizException e) {
                log.error("\u53d8\u66f4\u57fa\u7840\u5e94\u7528\u8868\u3010{}\u3011\u5931\u8d25,\u8bf7\u624b\u52a8\u6267\u884c", (Object)table);
            }
        }
    }
}

