/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.init;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.manatee.common.domain.DBQuery;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.CryptoUtils;
import com.manatee.lowcode.baseModule.manager.BaseModuleUtil;
import com.manatee.lowcode.constant.JavaCompilerSo;
import com.manatee.lowcode.java.manager.IJavaCode;
import com.manatee.lowcode.java.manager.JavaProcessManager;
import com.manatee.lowcode.manager.LowcodeCompilerManager;
import com.manatee.lowcodedb.base.DBReadUtil;
import com.manatee.manager.node.biz.NodeProcessManager;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;

@Service
public class InitCompiler
implements ApplicationContextAware {
    private static Logger LOGGER = LoggerFactory.getLogger(InitCompiler.class);
    private ScheduledExecutorService EXECUTOR = Executors.newScheduledThreadPool(1);
    private ApplicationContext applicationcontext;
    @Value(value="${default-database-product-name:mysql}")
    private String defaultDatabaseProductName;
    @Resource
    private DBReadUtil dbReadUtil;
    @Resource
    private JavaProcessManager javaProcessManager;
    @Resource
    private LowcodeCompilerManager lowcodeCompilerManager;
    @Value(value="${manatee.java.ignoreErrors:false}")
    private Boolean javaIgnoreErrors;
    @Value(value="${manatee.java.processScanTimeInterval:3}")
    private Integer javaProcessScanTimeInterval;
    @Resource
    private BaseModuleUtil baseModuleUtil;

    @PostConstruct
    @DependsOn(value={"initBaseTable"})
    public void onApplicationEvent() {
        if (!this.baseModuleUtil.isExistTable("lowcode_compiler")) {
            this.baseModuleUtil.initBaseTable("lowcode_compiler");
        }
        try {
            LOGGER.debug("start server compiler");
            this.saveLowcodeCompiler(this.javaIgnoreErrors);
        }
        catch (BizException e) {
            LOGGER.error("compiler", (Throwable)e);
        }
        if (this.javaProcessScanTimeInterval < 1) {
            this.javaProcessScanTimeInterval = 1;
        }
        this.EXECUTOR.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    LOGGER.debug("saveLowcodeCompiler");
                    InitCompiler.this.saveLowcodeCompiler(true);
                }
                catch (BizException e) {
                    LOGGER.error("saveLowcodeCompiler", (Throwable)e);
                }
            }
        }, 10L, this.javaProcessScanTimeInterval.intValue(), TimeUnit.MINUTES);
    }

    private void saveLowcodeCompiler(Boolean ignoreErrors) throws BizException {
        JSONArray baseModuleList = this.findModules();
        if (baseModuleList == null || baseModuleList.size() <= 0) {
            return;
        }
        for (int i = 0; i < baseModuleList.size(); ++i) {
            String beanName;
            JSONArray steps;
            JSONObject baseModule = baseModuleList.getJSONObject(i);
            JSONObject processConf = null;
            try {
                processConf = JSONObject.parseObject((String)baseModule.getString("processConf"), (Feature[])new Feature[]{Feature.OrderedField});
            }
            catch (Exception e) {
                LOGGER.error("saveLowcodeCompiler error ,baseModule:\u3010{}\u3011", (Object)baseModule);
            }
            if (processConf == null || (steps = NodeProcessManager.getAllSteps((JSONArray)processConf.getJSONArray("steps"), null)) == null || steps.size() <= 0) continue;
            Long baseModuleId = baseModule.getLong("id");
            JSONArray compers = this.lowcodeCompilerManager.findCompers(baseModuleId);
            HashMap<String, Map> nameAndComperMap = new HashMap<String, Map>();
            for (int n = 0; n < compers.size(); ++n) {
                Map jsonObject = (Map)compers.get(n);
                beanName = (String)jsonObject.get("bean_name");
                nameAndComperMap.put(beanName, jsonObject);
            }
            for (int j = 0; j < steps.size(); ++j) {
                JSONObject step = steps.getJSONObject(j);
                if (!"javaProcess".equals(step.getString("name"))) continue;
                beanName = "run_" + step.getString("id").replaceAll("-", "");
                JavaCompilerSo javaCompilerSo = new JavaCompilerSo();
                String importStr = step.getString("import");
                String javaCodeStr = step.getString("javaCode");
                String resourceStr = step.getString("resource");
                String valueStr = step.getString("value");
                javaCompilerSo.setImportStr(importStr);
                javaCompilerSo.setJavaCodeStr(javaCodeStr);
                javaCompilerSo.setResourceStr(resourceStr);
                javaCompilerSo.setValueStr(valueStr);
                javaCompilerSo.setBeanName(beanName);
                String inStepCode = JavaProcessManager.formatCode(javaCompilerSo.getImportStr(), javaCompilerSo.getBeanName(), javaCompilerSo.getJavaCodeStr(), javaCompilerSo.getResourceStr(), javaCompilerSo.getValueStr());
                javaCompilerSo.setFormatCode(inStepCode);
                Map compiler = (Map)nameAndComperMap.get(beanName);
                try {
                    String version = CryptoUtils.encodeMD5((String)inStepCode);
                    boolean isReLoad = this.javaProcessManager.checkVersionAndLoad(compiler, version);
                    if (isReLoad) continue;
                    IJavaCode javaCode = (IJavaCode)this.javaProcessManager.getBean(beanName);
                    if (javaCode != null) {
                        this.javaProcessManager.removeBeanDefinition(beanName);
                    }
                    Class clazz = this.javaProcessManager.createIJavaCode(javaCompilerSo);
                    javaCode = this.javaProcessManager.registerSingleton(clazz, beanName, version);
                }
                catch (Exception e) {
                    String title = step.getString("title");
                    String moduleName = baseModule.getString("moduleName");
                    String projectId = baseModule.getString("projectId");
                    LOGGER.error("compiler error\uff0cmoduleName:\u3010{}\u3011, stepTitle:\u3010{}\u3011,  moduleId:\u3010{}\u3011\uff0cprojectId\uff1a\u3010{}\u3011", new Object[]{moduleName, title, baseModule.get((Object)"id"), projectId, e});
                    if (ignoreErrors.booleanValue()) continue;
                    SpringApplication.exit((ApplicationContext)this.applicationcontext, (ExitCodeGenerator[])new ExitCodeGenerator[0]);
                    System.exit(1);
                    continue;
                }
                if (compiler == null) {
                    Long moduleId = baseModule.getLong("id");
                    Long projectId = baseModule.getLong("projectId");
                    this.lowcodeCompilerManager.saveCompiler(projectId, moduleId, beanName, inStepCode, javaCompilerSo.getCompilerData());
                    continue;
                }
                String compilerCode = (String)compiler.get("compiler_code");
                if (CryptoUtils.encodeMD5((String)inStepCode).equals(CryptoUtils.encodeMD5((String)compilerCode))) continue;
                Long id = (Long)compiler.get("id");
                this.lowcodeCompilerManager.updateCompilerById(id, inStepCode, javaCompilerSo.getCompilerData(), 0);
            }
        }
    }

    private JSONArray findModules() throws BizException {
        DBQuery moduleDbQuery = new DBQuery();
        moduleDbQuery.setDatabaseProductName(this.defaultDatabaseProductName);
        moduleDbQuery.setTable("lowcode_base_module");
        moduleDbQuery.setSelectOne(Boolean.valueOf(true));
        moduleDbQuery.setCamelCase(Boolean.valueOf(true));
        moduleDbQuery.setUpperOrLowerCase("lowerCase");
        HashMap<String, Integer> moduleConditionMap = new HashMap<String, Integer>();
        moduleConditionMap.put("valid", 0);
        moduleDbQuery.setCondition("process_conf is not NULL");
        moduleDbQuery.setConditionMap(moduleConditionMap);
        moduleDbQuery.setDb("hainiu_lowcode");
        moduleDbQuery.setSelectOne(Boolean.valueOf(false));
        JSONArray baseModuleList = (JSONArray)this.dbReadUtil.find(moduleDbQuery);
        return baseModuleList;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationcontext = applicationContext;
    }
}

