/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.file.process;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.Session;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.file.base.ChannelSftpFactory;
import com.manatee.file.base.SftpUtils;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SftpDownloadProcess
implements IProcess {
    private static Logger LOGGER = LoggerFactory.getLogger(SftpDownloadProcess.class);
    @Autowired
    private ProcessConfUtil processConfUtil;
    @Resource
    private VariableUtil variableUtil;
    @Resource
    private ChannelSftpFactory channelSftpFactory;
    @Resource
    protected IOutputUtil outputUtil;

    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"downloadFileName"});
        String downloadFileName = this.variableUtil.calVarInConf(content, "downloadFileName");
        Boolean downLoadNow = content.getStepConf().getBoolean("downLoadNow");
        this.processConfUtil.checkConf(content, new String[]{"downloadLocalPath"});
        String localPath = this.variableUtil.calVarInConf(content, "downloadLocalPath");
        Session sshSession = null;
        ChannelSftp channelSftp = this.channelSftpFactory.sftpConnection(sshSession, content);
        try {
            String directory = "/";
            if (downloadFileName.indexOf("/") != -1) {
                int index = downloadFileName.lastIndexOf("/");
                directory = downloadFileName.substring(0, index);
            }
            SftpUtils.download(directory, downloadFileName, localPath, channelSftp);
        }
        catch (Exception e) {
            LOGGER.error("SftpDownloadProcess \u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25", (Throwable)e);
            throw new BizException(ResultCode.CONF_ERROR, "\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25 :" + e.getMessage());
        }
        finally {
            SftpUtils.sftpClose(channelSftp);
            SftpUtils.sessionClose(sshSession);
        }
        if (downLoadNow != null && downLoadNow.booleanValue()) {
            content.getStepConf().put("returnKey", (Object)"lowcodeTempFileUrl");
            this.outputUtil.putData(content, (Object)localPath);
        }
    }

    public String getName() {
        return "sftpDownload";
    }
}

