/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.process;

import com.alibaba.fastjson.JSONArray;
import com.manatee.common.domain.DBQuery;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.lowcode.util.OutputUtil;
import com.manatee.lowcodedb.manager.DBAopManager;
import com.manatee.lowcodedb.manager.DBManager;
import com.manatee.lowcodedb.newdb.DbClient;
import com.manatee.lowcodedb.newdb.DbEntity;
import com.manatee.lowcodedb.newdb.DbQueryAopBo;
import com.manatee.lowcodedb.newdb.ThreadLocalConnection;
import com.manatee.lowcodedb.newdb.ds.DSFactory;
import com.manatee.lowcodedb.newdb.ds.DataSourceWrapper;
import com.manatee.lowcodedb.newdb.sql.Join;
import com.manatee.lowcodedb.newdb.tenant.manager.TenantManager;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ManateeCountProcess
implements IProcess {
    private Logger LOGGER = LoggerFactory.getLogger(ManateeCountProcess.class);
    @Resource
    private IVariableUtil variableUtil;
    @Resource
    private DBManager dBManager;
    @Resource
    protected OutputUtil outputUtil;
    @Resource
    private TenantManager tenantManager;
    @Resource
    private DBAopManager dbAopManager;

    public void process(ProcessContent content) throws BizException {
        String db = this.variableUtil.calVarInConf(content, "db");
        DataSourceWrapper dataSource = (DataSourceWrapper)DSFactory.get(db);
        String dataBaseName = this.variableUtil.calVarInConf(content, "schema");
        if (StringUtil.isBlank((String)dataBaseName)) {
            dataBaseName = dataSource.getDataBaseName();
        }
        DbEntity dbEntity = this.createDbEntity(content, dataBaseName);
        long count = 0L;
        ThreadLocalConnection.INSTANCE.setProcessContent(content);
        try {
            count = DbClient.use(db).count(dbEntity);
        }
        catch (SQLException e) {
            this.LOGGER.error("ManateeCountProcess error , db:\u3010{}\u3011", (Object)db);
            throw new BizException((Throwable)e);
        }
        finally {
            ThreadLocalConnection.INSTANCE.removeProcessContent();
        }
        String table = this.variableUtil.calVarInConf(content, "table");
        DbQueryAopBo dbQueryAopBo = new DbQueryAopBo();
        dbQueryAopBo.setTableName(table);
        dbQueryAopBo.setBatch(false);
        dbQueryAopBo.setResultData(count);
        this.dbAopManager.queryAfterFun(content, dbQueryAopBo);
        this.outputUtil.setDefaultReturnKey(content, "count");
        this.outputUtil.putData(content, (Object)count);
    }

    public String getName() {
        return "manateeCountProcess";
    }

    private DbEntity createDbEntity(ProcessContent content, String dataBaseName) throws BizException {
        String table = this.variableUtil.calVarInConf(content, "table");
        String syntaxType = content.getStepConf().getString("syntaxType");
        List<Map> queryListParams = this.dBManager.getQueryListParamsV2(content, syntaxType);
        DbQueryAopBo dbQueryAopBo = new DbQueryAopBo();
        dbQueryAopBo.setTableName(table);
        dbQueryAopBo.setBatch(false);
        dbQueryAopBo.setWhereParams(queryListParams);
        this.dbAopManager.queryBeforeFun(content, dbQueryAopBo);
        JSONArray in = this.dBManager.in(content);
        DBQuery query = new DBQuery();
        this.dBManager.in(in, query);
        this.dBManager.join(content, query);
        DbEntity dbEntity = DbEntity.create(dataBaseName + '.' + table).setWhereConditionListForDbQuery(table, queryListParams, content).setInConditionForDbQuery(table, query.getIn());
        Collection<Join> joins = dbEntity.setJoinConditionForDbQuery(query.getJoin(), content, dataBaseName, this.variableUtil);
        dbEntity.setJoins(joins);
        this.tenantManager.addTenantToEntity(content, dbEntity);
        return dbEntity;
    }
}

