/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.base;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.DBInsert;
import com.manatee.common.domain.DBUpdate;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.lowcodedb.base.DBWriteBase;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.springframework.stereotype.Service;

@Service
public class DBWriteUtil
extends DBWriteBase {
    public int delete(DBUpdate delete, String db, Connection transactionCon) throws BizException {
        Statement ps = null;
        Connection con = null;
        try {
            con = transactionCon != null ? transactionCon : this.manateeDataSource.getConnection(db);
            String databaseProductName = con.getMetaData().getDatabaseProductName().toLowerCase();
            delete.setDatabaseProductName(databaseProductName);
            int n = this.delete(delete, con, (PreparedStatement)ps);
            return n;
        }
        catch (SQLException e) {
            throw new BizException(ResultCode.SYSTEM_ERROR, (Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            if (transactionCon == null) {
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public int update(DBUpdate update, Connection transactionCon) throws BizException {
        Statement ps = null;
        Connection con = null;
        try {
            con = transactionCon != null ? transactionCon : this.manateeDataSource.getConnection(update.getDb());
            String databaseProductName = con.getMetaData().getDatabaseProductName().toLowerCase();
            update.setDatabaseProductName(databaseProductName);
            int n = this.update(update, con, (PreparedStatement)ps);
            return n;
        }
        catch (SQLException e) {
            throw new BizException(ResultCode.SYSTEM_ERROR, (Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            if (transactionCon == null) {
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public JSONObject insert(DBInsert insert, String db, Connection transactionCon) throws BizException {
        Statement ps = null;
        Connection con = null;
        try {
            con = transactionCon != null ? transactionCon : this.manateeDataSource.getConnection(db);
            String databaseProductName = con.getMetaData().getDatabaseProductName().toLowerCase();
            insert.setDatabaseProductName(databaseProductName);
            JSONObject jSONObject = this.insert(insert, con, (PreparedStatement)ps);
            return jSONObject;
        }
        catch (SQLException e) {
            throw new BizException(ResultCode.SYSTEM_ERROR, (Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            if (transactionCon == null) {
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

