/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Formatter {
    private static final String[] SPACES = new String[]{" ", "  ", "    ", "        ", "                ", "                                "};
    private static final CachingDateFormatter CACHING_DATE_FORMATTER = new CachingDateFormatter("yyyy-MM-dd HH:mm:ss.SSS");
    private static final TargetLengthBasedClassNameAbbreviator ABBREVIATOR = new TargetLengthBasedClassNameAbbreviator(39);
    private StringBuilder buf = new StringBuilder();

    private Formatter() {
    }

    public static Formatter create() {
        return new Formatter();
    }

    private static void leftPad(StringBuilder buf, String s, int desiredLength) {
        int actualLen = 0;
        if (s != null) {
            actualLen = s.length();
        }
        if (actualLen < desiredLength) {
            Formatter.spacePad(buf, desiredLength - actualLen);
        }
        if (s != null) {
            buf.append(s);
        }
    }

    private static void rightPad(StringBuilder buf, String s, int desiredLength) {
        int actualLen = 0;
        if (s != null) {
            actualLen = s.length();
        }
        if (s != null) {
            buf.append(s);
        }
        if (actualLen < desiredLength) {
            Formatter.spacePad(buf, desiredLength - actualLen);
        }
    }

    private static void spacePad(StringBuilder sbuf, int length) {
        while (length >= 32) {
            sbuf.append(SPACES[5]);
            length -= 32;
        }
        for (int i = 4; i >= 0; --i) {
            if ((length & 1 << i) == 0) continue;
            sbuf.append(SPACES[i]);
        }
    }

    public Formatter timestamp(long timestamp) {
        this.buf.append(CACHING_DATE_FORMATTER.format(timestamp));
        return this;
    }

    public Formatter space() {
        this.buf.append(SPACES[0]);
        return this;
    }

    public Formatter value(String value) {
        this.buf.append(value);
        return this;
    }

    public Formatter newline() {
        this.buf.append("\n");
        return this;
    }

    public Formatter thread(String value) {
        return this.alignment(value, 15, 15, true, true);
    }

    public Formatter traceId(String requestId) {
        return this.alignment(requestId, 15, 32, true, true);
    }

    public Formatter level(String value) {
        return this.alignment(value, 5, Integer.MAX_VALUE, true, true);
    }

    public Formatter loggerName(String value) {
        return this.alignment(ABBREVIATOR.abbreviate(value), 40, 40, true, false);
    }

    public String toString() {
        return this.buf.toString();
    }

    public Formatter throwable(Throwable throwable) {
        if (throwable != null) {
            this.newline();
            StringWriter sw = new StringWriter(1024);
            PrintWriter writer = new PrintWriter(sw);
            throwable.printStackTrace(writer);
            writer.close();
            this.buf.append(sw.getBuffer());
            this.newline();
        }
        return this;
    }

    private Formatter alignment(String value, int min, int max, boolean leftTruncate, boolean leftPad) {
        if (value == null) {
            if (0 < min) {
                Formatter.spacePad(this.buf, min);
            }
        } else {
            int len = value.length();
            if (len > max) {
                if (leftTruncate) {
                    this.buf.append(value.substring(len - max));
                } else {
                    this.buf.append(value, 0, max);
                }
            } else if (len < min) {
                if (leftPad) {
                    Formatter.leftPad(this.buf, value, min);
                } else {
                    Formatter.rightPad(this.buf, value, min);
                }
            } else {
                this.buf.append(value);
            }
        }
        return this;
    }

    private static class TargetLengthBasedClassNameAbbreviator {
        final int targetLength;

        public TargetLengthBasedClassNameAbbreviator(int targetLength) {
            this.targetLength = targetLength;
        }

        public String abbreviate(String fqClassName) {
            StringBuilder buf = new StringBuilder(this.targetLength);
            if (fqClassName == null) {
                throw new IllegalArgumentException("Class name may not be null");
            }
            int inLen = fqClassName.length();
            if (inLen < this.targetLength) {
                return fqClassName;
            }
            int[] dotIndexesArray = new int[16];
            int[] lengthArray = new int[17];
            int dotCount = this.computeDotIndexes(fqClassName, dotIndexesArray);
            if (dotCount == 0) {
                return fqClassName;
            }
            this.computeLengthArray(fqClassName, dotIndexesArray, lengthArray, dotCount);
            for (int i = 0; i <= dotCount; ++i) {
                if (i == 0) {
                    buf.append(fqClassName.substring(0, lengthArray[i] - 1));
                    continue;
                }
                buf.append(fqClassName.substring(dotIndexesArray[i - 1], dotIndexesArray[i - 1] + lengthArray[i]));
            }
            return buf.toString();
        }

        int computeDotIndexes(String className, int[] dotArray) {
            int dotCount;
            int k = 0;
            for (dotCount = 0; (k = className.indexOf(46, k)) != -1 && dotCount < 16; ++dotCount) {
                dotArray[dotCount] = k++;
            }
            return dotCount;
        }

        void computeLengthArray(String className, int[] dotArray, int[] lengthArray, int dotCount) {
            int toTrim = className.length() - this.targetLength;
            for (int i = 0; i < dotCount; ++i) {
                int available;
                int len;
                int previousDotPosition = -1;
                if (i > 0) {
                    previousDotPosition = dotArray[i - 1];
                }
                int n = len = (available = dotArray[i] - previousDotPosition - 1) < 1 ? available : 1;
                len = toTrim > 0 ? (available < 1 ? available : 1) : available;
                toTrim -= available - len;
                lengthArray[i] = len + 1;
            }
            int lastDotIndex = dotCount - 1;
            lengthArray[dotCount] = className.length() - dotArray[lastDotIndex];
        }
    }

    private static class CachingDateFormatter {
        final SimpleDateFormat sdf;
        long lastTimestamp = -1L;
        String cachedStr = null;

        public CachingDateFormatter(String pattern) {
            this.sdf = new SimpleDateFormat(pattern);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final String format(long now) {
            CachingDateFormatter cachingDateFormatter = this;
            synchronized (cachingDateFormatter) {
                if (now != this.lastTimestamp) {
                    this.lastTimestamp = now;
                    this.cachedStr = this.sdf.format(new Date(now));
                }
                return this.cachedStr;
            }
        }
    }
}

