/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.fun.encrypt;

import com.manatee.fun.AbstractFunction;
import com.manatee.fun.domain.FunctionContent;
import com.manatee.lowcode.util.RSAUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RsaEncryptFun
extends AbstractFunction {
    private static Logger LOGGER = LoggerFactory.getLogger(RsaEncryptFun.class);

    public String getName() {
        return "rsaEncrypt";
    }

    public Object doFunction(FunctionContent content) {
        this.checkParamSize(content);
        if (!this.checkParamExist(content).booleanValue()) {
            return null;
        }
        List parameters = content.getParameters();
        String publicKey = (String)parameters.get(0);
        String param = (String)parameters.get(1);
        try {
            String encrypt = RSAUtil.encrypt((String)param, (String)publicKey);
            return encrypt;
        }
        catch (Exception e) {
            LOGGER.error("RsaEncryptFun, publicKey:{}, e:{}", (Object)publicKey, (Object)e);
            throw new RuntimeException(String.format("\u51fd\u6570\uff1a%s\uff0crsa\u52a0\u5bc6\u5931\u8d25\uff0c\u516c\u94a5\u9519\u8bef", this.getName()));
        }
    }

    public Integer getMinParamSize() {
        return 2;
    }

    public Integer getMaxParamSize() {
        return 2;
    }
}

