/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.fun.collection;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.util.tool.core.comparator.CompareUtil;
import com.manatee.fun.AbstractFunction;
import com.manatee.fun.domain.FunctionContent;
import com.manatee.process.util.ExpressionUtil;
import com.manatee.process.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.stereotype.Service;

@Service
public class ListFilterFun
extends AbstractFunction {
    private String name = "listFilter";

    public String getName() {
        return this.name;
    }

    public Object doFunction(FunctionContent content) {
        this.checkParamSize(content);
        this.checkParamExist(content);
        List<Object> result = new ArrayList();
        List parameters = content.getParameters();
        if (parameters == null || parameters.size() < 2 || parameters.get(0) == null) {
            return result;
        }
        List list = (List)parameters.get(0);
        String expression = parameters.get(1).toString();
        JSONArray conditionArray = ListFilterFun.getConditionArray(expression);
        boolean orSignal = expression.contains("||");
        result = ListFilterFun.getResultList(list, conditionArray, orSignal);
        return result;
    }

    public Integer getMinParamSize() {
        return 2;
    }

    public Integer getMaxParamSize() {
        return 2;
    }

    private static List<Object> getResultList(List<Object> list, JSONArray conditionArray, boolean orSignal) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object listElement : list) {
            boolean isAdequate = true;
            boolean needContinue = false;
            for (Object conditionObj : conditionArray) {
                JSONObject conditionJson = (JSONObject)conditionObj;
                boolean isSingleAdequate = ListFilterFun.isMeetTheCondition(listElement, conditionJson);
                if (orSignal && isSingleAdequate) {
                    result.add(listElement);
                    needContinue = true;
                    break;
                }
                isAdequate = isAdequate && isSingleAdequate;
            }
            if (needContinue || !isAdequate) continue;
            result.add(listElement);
        }
        return result;
    }

    private static JSONArray getConditionArray(String condition) {
        JSONArray conditionArray = new JSONArray();
        if (condition.contains("&&") && condition.contains("||")) {
            throw new RuntimeException("listFilter\u51fd\u6570\u5f02\u5e38,\u76ee\u524d\u4ec5\u652f\u6301\u4e00\u79cd\u6761\u4ef6\u8868\u8fbe\u5f0f\u7ec4\u5408(\u5168\u90e8\u4e3a&&\u6216\u5168\u90e8\u4e3a||)");
        }
        if (condition.contains("&&") || condition.contains("||")) {
            List conditionList = ExpressionUtil.getConditionList((String)condition);
            for (String conditionStr : conditionList) {
                JSONObject conditionJson = ListFilterFun.getConditionObj(conditionStr);
                conditionArray.add((Object)conditionJson);
            }
        } else {
            JSONObject conditionJson = ListFilterFun.getConditionObj(condition);
            conditionArray.add((Object)conditionJson);
        }
        return conditionArray;
    }

    private static JSONObject getConditionObj(String condition) {
        boolean flag;
        String value;
        String symbol;
        int index;
        JSONObject result = new JSONObject();
        if (condition.contains(" is not ")) {
            index = condition.indexOf(" is not ");
            symbol = condition.substring(index, index + 8);
            value = condition.substring(index + 8).trim();
        } else if (condition.contains(" is ")) {
            index = condition.indexOf(" is ");
            symbol = condition.substring(index, index + 4);
            value = condition.substring(index + 4).trim();
        } else if (condition.contains(">=")) {
            index = condition.indexOf(">=");
            symbol = condition.substring(index, index + 2);
            value = condition.substring(index + 2).trim();
        } else if (condition.contains("<=")) {
            index = condition.indexOf("<=");
            symbol = condition.substring(index, index + 2);
            value = condition.substring(index + 2).trim();
        } else if (condition.contains("!=")) {
            index = condition.indexOf("!=");
            symbol = condition.substring(index, index + 2);
            value = condition.substring(index + 2).trim();
        } else if (condition.contains("==")) {
            index = condition.indexOf("==");
            symbol = condition.substring(index, index + 2);
            value = condition.substring(index + 2).trim();
        } else if (condition.contains(">")) {
            index = condition.indexOf(">");
            symbol = condition.substring(index, index + 1);
            value = condition.substring(index + 1).trim();
        } else if (condition.contains("<")) {
            index = condition.indexOf("<");
            symbol = condition.substring(index, index + 1);
            value = condition.substring(index + 1).trim();
        } else if (condition.contains(" endsWith ")) {
            index = condition.indexOf(" endsWith ");
            symbol = condition.substring(index, index + 10);
            value = condition.substring(index + 10).trim();
        } else if (condition.contains(" startsWith ")) {
            index = condition.indexOf(" startsWith ");
            symbol = condition.substring(index, index + 12);
            value = condition.substring(index + 12).trim();
        } else {
            throw new RuntimeException("listFilter\u51fd\u6570\u5f02\u5e38,\u4e0d\u652f\u6301\u7684\u6761\u4ef6\u8868\u8fbe\u5f0f");
        }
        String key = condition.substring(0, index).trim();
        result.put("key", (Object)key.trim());
        result.put("symbol", (Object)symbol.trim());
        result.put("value", (Object)value);
        if (key.trim().isEmpty()) {
            throw new RuntimeException("listFilter\u51fd\u6570\u5f02\u5e38,\u8bf7\u68c0\u67e5\u8868\u8fbe\u5f0f\u662f\u5426\u6b63\u786e");
        }
        boolean bl = flag = symbol.contains(" is ") && !"null".equalsIgnoreCase(value.toString()) && !"empty".equalsIgnoreCase(value.toString()) && !"blank".equalsIgnoreCase(value.toString());
        if (flag) {
            throw new RuntimeException("listFilter\u51fd\u6570\u5f02\u5e38,\u8bf7\u68c0\u67e5\u8868\u8fbe\u5f0f\u662f\u5426\u6b63\u786e");
        }
        return result;
    }

    private static boolean isMeetTheCondition(Object listElement, JSONObject conditionJson) {
        String key = conditionJson.get((Object)"key").toString();
        String symbol = conditionJson.get((Object)"symbol").toString();
        Object rightObject = conditionJson.get((Object)"value");
        Object leftObject = listElement;
        if (!Objects.equals(key, "_this") && listElement instanceof Map) {
            JSONObject jsonObject = JSONObject.parseObject((String)JSON.toJSONString((Object)listElement));
            leftObject = jsonObject.get((Object)key);
        }
        return ListFilterFun.compareObject(leftObject, symbol, rightObject);
    }

    private static boolean compareObject(Object leftObject, String symbol, Object rightObject) {
        if (leftObject == null && !symbol.contains("is")) {
            return false;
        }
        if (symbol.contains(">") || symbol.contains("<")) {
            leftObject = Double.parseDouble(leftObject.toString());
            rightObject = Double.parseDouble(rightObject.toString());
        }
        boolean resultFlag = false;
        switch (symbol) {
            case ">": {
                if (CompareUtil.compare((Object)leftObject, (Object)rightObject, (boolean)false) <= 0) break;
                resultFlag = true;
                break;
            }
            case ">=": {
                if (CompareUtil.compare((Object)leftObject, (Object)rightObject, (boolean)false) < 0) break;
                resultFlag = true;
                break;
            }
            case "<": {
                if (CompareUtil.compare((Object)leftObject, (Object)rightObject, (boolean)false) >= 0) break;
                resultFlag = true;
                break;
            }
            case "<=": {
                if (CompareUtil.compare((Object)leftObject, (Object)rightObject, (boolean)false) > 0) break;
                resultFlag = true;
                break;
            }
            case "==": {
                if (CompareUtil.compare((Comparable)((Object)leftObject.toString()), (Comparable)((Object)rightObject.toString()), (boolean)false) != 0) break;
                resultFlag = true;
                break;
            }
            case "!=": {
                if (CompareUtil.compare((Comparable)((Object)leftObject.toString()), (Comparable)((Object)rightObject.toString()), (boolean)false) == 0) break;
                resultFlag = true;
                break;
            }
            case "is not": {
                if (leftObject == null) break;
                if ("null".equalsIgnoreCase(rightObject.toString())) {
                    resultFlag = true;
                    break;
                }
                if ("empty".equalsIgnoreCase(rightObject.toString()) && !leftObject.toString().isEmpty()) {
                    resultFlag = true;
                    break;
                }
                if (!"blank".equalsIgnoreCase(rightObject.toString()) || !StringUtil.isNotBlank((String)leftObject.toString())) break;
                resultFlag = true;
                break;
            }
            case "is": {
                if ("null".equalsIgnoreCase(rightObject.toString()) && leftObject == null) {
                    resultFlag = true;
                    break;
                }
                if ("empty".equalsIgnoreCase(rightObject.toString()) && (leftObject == null || leftObject.toString().isEmpty())) {
                    resultFlag = true;
                    break;
                }
                if (!"blank".equalsIgnoreCase(rightObject.toString()) || leftObject != null && !StringUtil.isBlank((String)leftObject.toString())) break;
                resultFlag = true;
                break;
            }
            case "startsWith": {
                if (!leftObject.toString().startsWith(rightObject.toString())) break;
                resultFlag = true;
                break;
            }
            case "endsWith": {
                if (!leftObject.toString().endsWith(rightObject.toString())) break;
                resultFlag = true;
                break;
            }
        }
        return resultFlag;
    }
}

