/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.domain;

import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.tool.core.convert.Convert;
import com.manatee.lowcode.domain.CustomizeProcessDTO;
import com.manatee.lowcode.domain.ManateeParamsDTO;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.util.ArrayList;
import java.util.List;

public class CustomizeProcessImpl
implements IProcess {
    private CustomizeProcessDTO customizeProcessDTO;
    private IOutputUtil outputUtil;

    public CustomizeProcessImpl(CustomizeProcessDTO customizeProcessDTO, IOutputUtil outputUtil) {
        this.customizeProcessDTO = customizeProcessDTO;
        this.outputUtil = outputUtil;
    }

    @Override
    public void process(ProcessContent content) throws BizException {
        List<ManateeParamsDTO> manateeParams = this.customizeProcessDTO.getManateeParams();
        ArrayList params = new ArrayList(manateeParams.size());
        for (ManateeParamsDTO manateeParam : manateeParams) {
            String confParamsName = manateeParam.getParamsName();
            if (manateeParam.isRequired() && confParamsName == null) {
                throw new BizException(ResultCode.CONF_ERROR, String.format("%s\u4e0d\u80fd\u4e3a\u7a7a!", confParamsName));
            }
            if (manateeParam == null) {
                params.add(null);
                continue;
            }
            String paramsName = content.getStepConf().getString(confParamsName);
            Object objVlaue = content.getValue(paramsName);
            Object value = Convert.convert(manateeParam.getDataTypeClass(), objVlaue);
            params.add(value);
        }
        Object result = this.customizeProcessDTO.invoke(params.toArray());
        this.outputUtil.putData(content, result);
    }

    @Override
    public String getName() {
        return this.customizeProcessDTO.getName();
    }

    private CustomizeProcessImpl() {
    }

    public CustomizeProcessDTO getCustomizeProcessDTO() {
        return this.customizeProcessDTO;
    }

    public IOutputUtil getOutputUtil() {
        return this.outputUtil;
    }

    public void setCustomizeProcessDTO(CustomizeProcessDTO customizeProcessDTO) {
        this.customizeProcessDTO = customizeProcessDTO;
    }

    public void setOutputUtil(IOutputUtil outputUtil) {
        this.outputUtil = outputUtil;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomizeProcessImpl)) {
            return false;
        }
        CustomizeProcessImpl other = (CustomizeProcessImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CustomizeProcessDTO this$customizeProcessDTO = this.getCustomizeProcessDTO();
        CustomizeProcessDTO other$customizeProcessDTO = other.getCustomizeProcessDTO();
        if (this$customizeProcessDTO == null ? other$customizeProcessDTO != null : !((Object)this$customizeProcessDTO).equals(other$customizeProcessDTO)) {
            return false;
        }
        IOutputUtil this$outputUtil = this.getOutputUtil();
        IOutputUtil other$outputUtil = other.getOutputUtil();
        return !(this$outputUtil == null ? other$outputUtil != null : !this$outputUtil.equals(other$outputUtil));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CustomizeProcessImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CustomizeProcessDTO $customizeProcessDTO = this.getCustomizeProcessDTO();
        result = result * 59 + ($customizeProcessDTO == null ? 43 : ((Object)$customizeProcessDTO).hashCode());
        IOutputUtil $outputUtil = this.getOutputUtil();
        result = result * 59 + ($outputUtil == null ? 43 : $outputUtil.hashCode());
        return result;
    }

    public String toString() {
        return "CustomizeProcessImpl(customizeProcessDTO=" + this.getCustomizeProcessDTO() + ", outputUtil=" + this.getOutputUtil() + ")";
    }
}

