/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.util.tool.crypto.digest.otp;

import com.manatee.common.util.tool.crypto.digest.HmacAlgorithm;
import com.manatee.common.util.tool.crypto.digest.otp.HOTP;
import java.time.Duration;
import java.time.Instant;

public class TOTP
extends HOTP {
    public static final Duration DEFAULT_TIME_STEP = Duration.ofSeconds(30L);
    private final Duration timeStep;

    public TOTP(byte[] key) {
        this(DEFAULT_TIME_STEP, key);
    }

    public TOTP(Duration timeStep, byte[] key) {
        this(timeStep, 6, key);
    }

    public TOTP(Duration timeStep, int passwordLength, byte[] key) {
        this(timeStep, passwordLength, HOTP_HMAC_ALGORITHM, key);
    }

    public TOTP(Duration timeStep, int passwordLength, HmacAlgorithm algorithm, byte[] key) {
        super(passwordLength, algorithm, key);
        this.timeStep = timeStep;
    }

    public int generate(Instant timestamp) {
        return this.generate(timestamp.toEpochMilli() / this.timeStep.toMillis());
    }

    public Duration getTimeStep() {
        return this.timeStep;
    }
}

