/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.sentinel.process;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.exception.BizException;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.process.IProcess;
import com.manatee.process.ProcessChain;
import com.manatee.process.ProcessDataSource;
import com.manatee.process.domain.ProcessContent;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SentinelProcess
implements IProcess {
    private Logger log = LoggerFactory.getLogger(SentinelProcess.class);
    @Resource
    private ProcessChain processChain;
    @Resource
    private ProcessConfUtil processConfUtil;
    @Resource
    private IVariableUtil variableUtil;

    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"steps", "resource"});
        String resource = this.variableUtil.calVarInConf(content, "resource");
        try (Entry entry = SphU.entry((String)resource);){
            JSONObject conf = content.getStepConf();
            this.doSteps(content, conf);
        }
        catch (BlockException ex) {
            this.log.warn(resource + "\u88ab\u9650\u6d41");
        }
    }

    private void doSteps(ProcessContent content, JSONObject conf) throws BizException {
        List steps = ProcessDataSource.formatSteps((JSONObject)conf);
        this.processChain.executeSteps(content, steps);
    }

    public String getName() {
        return "sentinelProcess";
    }
}

