/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.rocketmq.manager;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.util.JSONUtils;
import com.manatee.lowcode.domain.ModularityResult;
import com.manatee.lowcode.web.manager.ModularityManager;
import java.util.HashMap;
import java.util.List;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.common.message.MessageExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ManateeMsgListenerManager
implements MessageListenerConcurrently {
    private Logger log = LoggerFactory.getLogger(ManateeMsgListenerManager.class);
    @Autowired
    private ModularityManager modularityManager;

    public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> list, ConsumeConcurrentlyContext consumeConcurrentlyContext) {
        boolean isSuccess = true;
        for (MessageExt messageExt : list) {
            this.log.warn("\u6536\u5230\u6d88\u606f\uff1atopic:" + messageExt.getTopic() + ",tags\uff1a" + messageExt.getTags() + ",keys\uff1a" + messageExt.getKeys());
            Long projectId = 0L;
            String code = "msgDistribute";
            JSONObject params = new HashMap();
            String value = new String(messageExt.getBody());
            if (JSONUtils.isJson((String)value)) {
                params = JSONObject.parseObject((String)value);
            } else {
                params.put("value", value);
            }
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("_type", messageExt.getTopic());
            param.put("_subType", messageExt.getTags());
            if (params.containsKey("_uniqueid")) {
                param.put("_uniqueId", (String)params.get("_uniqueid"));
            }
            param.put("params", (String)params);
            ModularityResult modularityResult = this.modularityManager.executionModule(projectId, code, param);
            if (!modularityResult.isSuccess()) {
                isSuccess = false;
            }
            this.log.warn(JSONObject.toJSONString((Object)modularityResult));
        }
        if (isSuccess) {
            return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
        }
        return ConsumeConcurrentlyStatus.RECONSUME_LATER;
    }
}

