/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.webservice.listener;

import com.manatee.webservice.annotation.RestWS;
import java.util.Map;
import org.apache.cxf.Bus;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class CxfRestWebServiceListener
implements ApplicationContextAware,
ApplicationListener<ContextRefreshedEvent> {
    private ApplicationContext applicationContext;
    @Autowired
    private Bus bus;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        Map beansWithAnnotation = this.applicationContext.getBeansWithAnnotation(RestWS.class);
        for (Map.Entry entry : beansWithAnnotation.entrySet()) {
            JAXRSServerFactoryBean jaxrsServerFactoryBean = new JAXRSServerFactoryBean();
            jaxrsServerFactoryBean.setBus(this.bus);
            jaxrsServerFactoryBean.setAddress("/" + (String)entry.getKey());
            jaxrsServerFactoryBean.setResourceProvider((ResourceProvider)new SingletonResourceProvider(entry.getValue()));
            jaxrsServerFactoryBean.setResourceClasses(new Class[]{entry.getValue().getClass()});
            jaxrsServerFactoryBean.create();
        }
    }
}

