/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.ecmascript;

import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcode.ecmascript.ECMAScriptLexer;
import com.manatee.lowcode.ecmascript.ECMAScriptParser;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;

public class ManateeeScriptParser {
    private static final Set<String> FILTER_ARGS = new HashSet(){
        {
            this.add("_fun");
            this.add("Java");
            this.add("log");
        }
    };

    private static void test01() {
        List<String> all = ManateeeScriptParser.parserAllAges("aa =_fun.aa(ccc,bbb)");
        System.out.println(all);
        List<String> all2 = ManateeeScriptParser.parserAllAges("aa = for(i =0 ; i< list.size(); i++) ");
        System.out.println(all2);
        List<String> all3 = ManateeeScriptParser.parserAllAges("aa = new com.manatee.xxxx()");
        System.out.println(all3);
        List<String> all4 = ManateeeScriptParser.parserAllAges("aa = new com.manatee.xxxx(bb, ccc)");
        System.out.println(all4);
        List<String> all5 = ManateeeScriptParser.parserAllAges("aa = new com.manatee.xxxx(bb, ccc, _fun.add(11, \"ooo\", ddd))");
        System.out.println(all5);
        List<String> all6 = ManateeeScriptParser.parserAllAges("aa = Java.type(\"bb.ccc\")");
        System.out.println(all6);
        List<String> all7 = ManateeeScriptParser.parserAllAges("aa = log.info(\"aaaa\", aaa)");
        System.out.println(all7);
    }

    public static List<String> parserAllAges(String code) {
        ArrayList<String> all = new ArrayList<String>();
        if (StrUtil.isBlank((CharSequence)code)) {
            return all;
        }
        ECMAScriptLexer lexer = new ECMAScriptLexer((CharStream)CharStreams.fromString((String)code));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        ECMAScriptParser parser = new ECMAScriptParser((TokenStream)tokens);
        ECMAScriptParser.SourceElementsContext tree = parser.sourceElements();
        int childCount = tree.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            ParseTree child = tree.getChild(i);
            List<String> allAgs = ManateeeScriptParser.getAllAgs(child);
            all.addAll(allAgs);
        }
        return all;
    }

    private static List<String> getAllAgs(ParseTree child) {
        ArrayList<String> list = new ArrayList<String>();
        if (child == null) {
            return list;
        }
        int childCount = child.getChildCount();
        if (childCount <= 0) {
            return list;
        }
        for (int i = 0; i < childCount; ++i) {
            ParseTree child1 = child.getChild(i);
            if (child1 instanceof ECMAScriptParser.IdentifierExpressionContext) {
                String text = child1.getText();
                if (FILTER_ARGS.contains(text) || list.contains(text)) continue;
                list.add(text);
                continue;
            }
            if (child1 instanceof ECMAScriptParser.NewExpressionContext) {
                ECMAScriptParser.NewExpressionContext newchild1 = (ECMAScriptParser.NewExpressionContext)child1;
                ParseTree newchild2 = newchild1.getChild(0);
                if (StrUtil.equals((CharSequence)"log", (CharSequence)newchild2.getText()) || StrUtil.equals((CharSequence)"Java", (CharSequence)newchild2.getText())) continue;
                ECMAScriptParser.ArgumentsExpressionContext child2 = (ECMAScriptParser.ArgumentsExpressionContext)newchild1.getChild(1);
                ECMAScriptParser.ArgumentsContext arguments = child2.arguments();
                List<String> allAgs = ManateeeScriptParser.getAllAgs((ParseTree)arguments);
                list.addAll(allAgs);
                continue;
            }
            List<String> allAgs = ManateeeScriptParser.getAllAgs(child1);
            list.addAll(allAgs);
        }
        return list;
    }
}

