/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.sqlserver.store;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.DBInsert;
import com.manatee.common.domain.DBUpdate;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcode.fun.collection.GetListDiff;
import com.manatee.lowcodedb.base.DBWriteUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.util.domain.StrSplit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SqlserverBatchHandle
implements IProcess {
    @Resource
    private GetListDiff getListDiff;
    @Resource
    private DBWriteUtil dbWriteUtil;

    public void process(ProcessContent content) throws BizException {
        List list2notEqual;
        String kewword;
        Map difMap;
        List list1Nonelist2Have;
        String key1 = content.getStepConfString("dbList");
        String key2 = content.getStepConfString("inputList");
        ArrayList list1 = (ArrayList)content.getValue(key1);
        ArrayList list2 = (ArrayList)content.getValue(key2);
        if (list1 == null && list2 == null) {
            return;
        }
        if (list1 == null) {
            list1 = new ArrayList();
        }
        if (list2 == null) {
            list2 = new ArrayList();
        }
        if ((list1Nonelist2Have = (List)(difMap = this.getListDiff.getListDiff(list1, list2, kewword = content.getStepConfString("keyword"))).get("list1Nonelist2Have")).size() > 0) {
            this.batchInsert(content, list1Nonelist2Have);
        }
        if ((list2notEqual = (List)difMap.get("list2notEqual")).size() > 0) {
            this.batchUpdate(content, list2notEqual);
        }
    }

    public String getName() {
        return "sqlServerBatchHandle";
    }

    private void batchInsert(ProcessContent content, List<Map<String, Object>> list) throws BizException {
        DBInsert insert = new DBInsert();
        insert.setBatch(true);
        insert.setInsertColumnsBatch(list);
        JSONObject conf = content.getStepConf();
        String table = conf.getString("table");
        String db = conf.getString("db");
        insert.setTable(table);
        this.dbWriteUtil.insert(insert, db, content.getTransactionCon());
    }

    private void batchUpdate(ProcessContent content, List<Map<String, Object>> list) throws BizException {
        JSONObject conf = content.getStepConf();
        String table = conf.getString("table");
        String db = conf.getString("db");
        String keyword = content.getStepConfString("keyword");
        String[] keywords = keyword.split(StrSplit.D);
        for (Map<String, Object> aMap : list) {
            DBUpdate update = new DBUpdate();
            update.setTable(table);
            update.setDb(db);
            this.initColums(update, aMap, keywords);
            this.dbWriteUtil.update(update, content.getTransactionCon());
        }
    }

    public void initColums(DBUpdate update, Map<String, Object> aMap, String[] keywords) {
        HashMap<String, Object> queryParam = new HashMap<String, Object>();
        HashMap<String, Object> updateParams = new HashMap<String, Object>();
        update.setQueryCondition(queryParam);
        update.setUpdateColumns(updateParams);
        for (int i = 0; i < keywords.length; ++i) {
            String keyword = keywords[i];
            if (StringUtil.isBlank((String)keyword)) continue;
            Object value = aMap.get(keyword);
            queryParam.put(keyword, value);
        }
        for (Map.Entry<String, Object> map : aMap.entrySet()) {
            String key = map.getKey();
            if (queryParam.get(key) != null) continue;
            Object value = map.getValue();
            updateParams.put(key, value);
        }
    }
}

