/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcode.iutil.IProcessConfUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.util.domain.StrSplit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ProcessConfUtil
implements IProcessConfUtil {
    protected Logger log = LoggerFactory.getLogger(ProcessConfUtil.class);
    private static String DEFAULT_VERSION = "1.0";
    @Resource
    private VariableUtil variableUtil;

    public void checkConf(ProcessContent content, String ... keys) throws BizException {
        JSONObject conf = content.getStepConf();
        if (conf == null) {
            throw new BizException(ResultCode.CONF_ERROR, "step_conf_is_null");
        }
        if (keys == null) {
            return;
        }
        for (String key : keys) {
            Object value = conf.get((Object)key);
            if (value == null) {
                BizException e = new BizException(ResultCode.CONF_ERROR, "step_conf_key_is_null");
                e.setConfKey(key);
                throw e;
            }
            if (!(value instanceof String) || !StringUtil.isBlank((String)(value + ""))) continue;
            BizException e = new BizException(ResultCode.CONF_ERROR, "step_conf_key_is_null");
            e.setConfKey(key);
            throw e;
        }
    }

    public static Object getGlobalConf(ProcessContent content, String key) {
        JSONObject conf = content.getProjectConf();
        if (conf == null) {
            return null;
        }
        JSONObject globalConf = conf.getJSONObject("conf");
        if (globalConf == null) {
            return null;
        }
        return globalConf.getJSONObject(key);
    }

    public Object getConf(ProcessContent content, String key, Object defaultValue) {
        Object conf = content.getStepConf(key);
        if (conf == null) {
            conf = defaultValue;
        }
        return conf;
    }

    public String getAParam(ProcessContent content, String key) throws BizException {
        String conf = (String)content.getStepConf(key);
        if (com.manatee.process.util.StringUtil.isBlank(conf)) {
            throw new BizException(ResultCode.PARAM_IS_ERROR, key + "_is_null");
        }
        return conf;
    }

    public JSONObject getParam(ProcessContent content) throws BizException {
        return this.getParam(content, null);
    }

    public JSONObject getParam(ProcessContent content, JSONObject conf) throws BizException {
        JSONObject param;
        if (conf == null) {
            conf = content.getStepConf();
        }
        if ((param = conf.getJSONObject("input")) == null) {
            return null;
        }
        String paramStr = this.variableUtil.calVar(content, param.toString());
        JSONObject paramJson = JSONObject.parseObject((String)paramStr);
        this.paramCheck(content, conf, paramJson);
        JSONObject paramType = conf.getJSONObject("inputType");
        if (paramType == null || paramType.size() == 0) {
            return paramJson;
        }
        JSONObject newParam = new JSONObject(true);
        for (String key : param.keySet()) {
            Object aValue = param.get((Object)key);
            Object value = this.format(paramType, key, aValue);
            newParam.put(key, value);
        }
        return newParam;
    }

    private Object format(JSONObject paramType, String key, Object value) throws BizException {
        String type = paramType.getString(key);
        if (StringUtil.isBlank((String)type)) {
            return value;
        }
        try {
            if ("Long".equals(type) || "java.lang.Long".equals(type)) {
                return Long.valueOf(value + "");
            }
            if ("Double".equals(type) || "java.lang.Double".equals(type)) {
                return Double.valueOf(value + "");
            }
        }
        catch (Throwable e) {
            throw new BizException(ResultCode.PARAM_IS_ERROR, type + "_is_error,value:" + value, e);
        }
        if (type.indexOf(com.manatee.common.domain.StrSplit.P) == -1) {
            return value;
        }
        if (!(value instanceof JSON)) {
            return value;
        }
        JSON valueJSON = (JSON)value;
        try {
            Class<?> cla = Class.forName(type);
            return JSON.toJavaObject((JSON)valueJSON, cla);
        }
        catch (ClassNotFoundException e) {
            throw new BizException(ResultCode.CONF_ERROR, type + ",not_found");
        }
    }

    private void paramCheck(ProcessContent content, JSONObject conf, JSONObject paramJson) throws BizException {
        if (conf == null) {
            conf = content.getStepConf();
        }
        if (conf.containsKey((Object)"inputCheck")) {
            String[] checkFields;
            String checkFieldStr = conf.getString("inputCheck");
            for (String checkField : checkFields = checkFieldStr.split(StrSplit.D)) {
                if (!StringUtil.isBlank((String)paramJson.getString(checkField))) continue;
                this.log.warn("[ProcessConfUtil.paramCheck]_biz_occur,msg:{}", (Object)("param_is_error>>" + checkField + "_is_null"));
                throw new BizException(ResultCode.PARAM_IS_ERROR, checkField + "_is_null");
            }
        }
    }
}

