/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.redis.process;

import com.manatee.common.exception.BizException;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.iutil.IProcessConfUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import com.manatee.redis.source.DtSourceManager;
import com.manatee.redis.util.RedisDbUtil;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RedisKeyExpireProcess
implements IProcess {
    private Logger log = LoggerFactory.getLogger(RedisKeyExpireProcess.class);
    @Resource
    private DtSourceManager dtSourceManager;
    @Resource
    private IOutputUtil outputUtil;
    @Resource
    private IProcessConfUtil processConfUtil;
    @Resource
    private IVariableUtil variableUtil;

    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"key"});
        int db = RedisDbUtil.getRedisDB(content);
        String objectKey = this.variableUtil.calVarInConf(content, "key");
        String time = this.variableUtil.calVarInConf(content, "time");
        boolean expire = this.dtSourceManager.getDtSource().expire(db, objectKey, Integer.valueOf(time)) == 1L;
        this.log.warn("[RedisKeyExpireProcess.process]_biz_occur,msg:{}", (Object)("expire:" + expire));
    }

    public String getName() {
        return "redisKeyExpire";
    }
}

