/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.newdb.sql;

import com.manatee.common.util.tool.core.collection.CollectionUtil;
import com.manatee.common.util.tool.core.util.ArrayUtil;
import com.manatee.lowcodedb.newdb.DbEntity;
import com.manatee.lowcodedb.newdb.DbRuntimeException;
import com.manatee.lowcodedb.newdb.Page;
import com.manatee.lowcodedb.newdb.sql.Condition;
import com.manatee.lowcodedb.newdb.sql.Join;
import com.manatee.lowcodedb.newdb.sql.Order;
import com.manatee.lowcodedb.newdb.sql.SqlUtil;
import java.util.Collection;

public class DBQuery {
    Collection<String> fields;
    String[] tableNames;
    Condition[] where;
    Page page;
    Order[] orders;
    Collection<Join> joins;
    boolean getOne;

    public static DBQuery of(DbEntity where) {
        return new DBQuery(SqlUtil.buildConditions(where), where.getTableName());
    }

    public DBQuery(String ... tableNames) {
        this((Condition[])null, tableNames);
        this.tableNames = tableNames;
    }

    public DBQuery(Condition[] where, String ... tableNames) {
        this(where, (Page)null, tableNames);
    }

    public DBQuery(Condition[] where, Page page, String ... tableNames) {
        this(null, tableNames, where, page);
    }

    public DBQuery(Collection<String> fields, String[] tableNames, Condition[] where, Page page) {
        this.fields = fields;
        this.tableNames = tableNames;
        this.where = where;
        this.page = page;
    }

    public Collection<String> getFields() {
        return this.fields;
    }

    public DBQuery setFields(Collection<String> fields) {
        this.fields = fields;
        return this;
    }

    public DBQuery setFields(String ... fields) {
        this.fields = CollectionUtil.newArrayList((Object[])fields);
        return this;
    }

    public String[] getTableNames() {
        return this.tableNames;
    }

    public DBQuery setTableNames(String ... tableNames) {
        this.tableNames = tableNames;
        return this;
    }

    public Condition[] getWhere() {
        return this.where;
    }

    public DBQuery setWhere(Condition ... where) {
        this.where = where;
        return this;
    }

    public Page getPage() {
        return this.page;
    }

    public DBQuery setPage(Page page) {
        this.page = page;
        return this;
    }

    public Order[] getOrders() {
        return this.orders;
    }

    public Collection<Join> getJoins() {
        return this.joins;
    }

    public DBQuery setOrders(Order[] orders) {
        this.orders = orders;
        return this;
    }

    public DBQuery setJoins(Collection<Join> joins) {
        this.joins = joins;
        return this;
    }

    public boolean getGetOne() {
        return this.getOne;
    }

    public DBQuery setGetOne(boolean getOne) {
        this.getOne = getOne;
        return this;
    }

    public String getFirstTableName() throws DbRuntimeException {
        if (ArrayUtil.isEmpty((Object[])this.tableNames)) {
            throw new DbRuntimeException("No tableName!");
        }
        return this.tableNames[0];
    }
}

