/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.newdb.dialect.impl;

import com.manatee.common.util.tool.core.collection.CollUtil;
import com.manatee.common.util.tool.core.lang.Assert;
import com.manatee.common.util.tool.core.lang.Filter;
import com.manatee.common.util.tool.core.util.ArrayUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcodedb.newdb.DbEntity;
import com.manatee.lowcodedb.newdb.DbRuntimeException;
import com.manatee.lowcodedb.newdb.Page;
import com.manatee.lowcodedb.newdb.StatementUtil;
import com.manatee.lowcodedb.newdb.dialect.DialectName;
import com.manatee.lowcodedb.newdb.dialect.impl.AnsiSqlDialect;
import com.manatee.lowcodedb.newdb.sql.SqlBuilder;
import com.manatee.lowcodedb.newdb.sql.Wrapper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Set;

public class SqlServer2012Dialect
extends AnsiSqlDialect {
    private static final long serialVersionUID = -37598166015777797L;

    public SqlServer2012Dialect() {
        this.wrapper = new Wrapper(Character.valueOf('\"'), this.dialectName());
    }

    @Override
    public SqlBuilder wrapPageSql(SqlBuilder find, Page page) {
        if (!StrUtil.containsIgnoreCase((CharSequence)find.toString(), (CharSequence)"order by")) {
            find.append(" order by current_timestamp");
        }
        return find.append(" offset ").append(page.getStartPosition()).append(" row fetch next ").append(page.getPageSize()).append(" row only");
    }

    @Override
    public String dialectName() {
        return DialectName.SQLSERVER2012.name();
    }

    @Override
    public PreparedStatement psForInsert(Connection conn, DbEntity entity) throws SQLException {
        if (entity.getInsertTypeEnum() != SqlBuilder.InsertTypeEnum.INSERT) {
            Assert.notBlank((CharSequence)entity.getPk(), (String)"\u4e3b\u952e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            SqlBuilder insert = SqlBuilder.create(this.wrapper).insertForSqlServer(entity);
            return StatementUtil.prepareStatement(conn, insert);
        }
        return super.psForInsert(conn, entity);
    }

    @Override
    public PreparedStatement psForInsertBatch(Connection conn, DbEntity ... entities) throws SQLException {
        SqlBuilder insert;
        if (ArrayUtil.isEmpty((Object[])entities)) {
            throw new DbRuntimeException("Entities for batch insert is empty !");
        }
        DbEntity entity = entities[0];
        if (entity.getInsertTypeEnum() != SqlBuilder.InsertTypeEnum.INSERT) {
            Assert.notBlank((CharSequence)entity.getPk(), (String)"\u4e3b\u952e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            insert = SqlBuilder.create(this.wrapper).insertForSqlServer(entity);
        } else {
            insert = SqlBuilder.create(this.wrapper).insert(entity, this.dialectName());
        }
        Set fields = (Set)CollUtil.filter((Collection)entity.keySet(), (Filter)new Filter<String>(){

            public boolean accept(String s) {
                return StrUtil.isNotBlank((CharSequence)s);
            }
        });
        return StatementUtil.prepareStatementForBatch(conn, insert.build(), fields, entities);
    }
}

