/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.newdb.dialect.impl;

import com.manatee.common.util.tool.core.collection.CollUtil;
import com.manatee.common.util.tool.core.lang.Assert;
import com.manatee.common.util.tool.core.lang.Filter;
import com.manatee.common.util.tool.core.util.ArrayUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcodedb.newdb.DbEntity;
import com.manatee.lowcodedb.newdb.DbRuntimeException;
import com.manatee.lowcodedb.newdb.Page;
import com.manatee.lowcodedb.newdb.StatementUtil;
import com.manatee.lowcodedb.newdb.dialect.DialectName;
import com.manatee.lowcodedb.newdb.dialect.impl.AnsiSqlDialect;
import com.manatee.lowcodedb.newdb.sql.SqlBuilder;
import com.manatee.lowcodedb.newdb.sql.Wrapper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Set;

public class DmDialect
extends AnsiSqlDialect {
    private static final long serialVersionUID = 6122761762247483015L;

    public static boolean isNextVal(Object value) {
        return value instanceof CharSequence && StrUtil.endWithIgnoreCase((CharSequence)value.toString(), (CharSequence)".nextval");
    }

    public DmDialect() {
        this.wrapper = new Wrapper(Character.valueOf('\"'), this.dialectName());
    }

    @Override
    public PreparedStatement psForInsert(Connection conn, DbEntity entity) throws SQLException {
        if (entity.getInsertTypeEnum() != SqlBuilder.InsertTypeEnum.INSERT) {
            Assert.notBlank((CharSequence)entity.getPk(), (String)"\u4e3b\u952e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            SqlBuilder insert = SqlBuilder.create(this.wrapper).insertForDameng(entity);
            return StatementUtil.prepareStatement(conn, insert);
        }
        return super.psForInsert(conn, entity);
    }

    @Override
    public PreparedStatement psForInsertBatch(Connection conn, DbEntity ... entities) throws SQLException {
        SqlBuilder insert;
        if (ArrayUtil.isEmpty((Object[])entities)) {
            throw new DbRuntimeException("Entities for batch insert is empty !");
        }
        DbEntity entity = entities[0];
        if (entity.getInsertTypeEnum() != SqlBuilder.InsertTypeEnum.INSERT) {
            Assert.notBlank((CharSequence)entity.getPk(), (String)"\u4e3b\u952e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            insert = SqlBuilder.create(this.wrapper).insertForDameng(entity);
        } else {
            insert = SqlBuilder.create(this.wrapper).insert(entity, this.dialectName());
        }
        Set fields = (Set)CollUtil.filter((Collection)entity.keySet(), (Filter)new Filter<String>(){

            public boolean accept(String s) {
                return StrUtil.isNotBlank((CharSequence)s);
            }
        });
        return StatementUtil.prepareStatementForBatch(conn, insert.build(), fields, entities);
    }

    @Override
    public SqlBuilder wrapPageSql(SqlBuilder find, Page page) {
        int[] startEnd = page.getStartEnd();
        return find.insertPreFragment("SELECT * FROM ( SELECT row_.*, rownum rownum_ from ( ").append(" ) row_ where rownum <= ").append(startEnd[1]).append(") table_alias_").append(" where table_alias_.rownum_ > ").append(startEnd[0]);
    }

    @Override
    public String dialectName() {
        return DialectName.DAMENG.name();
    }
}

