/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.newdb;

import com.manatee.common.util.tool.core.lang.Segment;
import com.manatee.common.util.tool.core.util.ArrayUtil;
import com.manatee.common.util.tool.core.util.PageUtil;
import com.manatee.lowcodedb.newdb.sql.Order;
import java.io.Serializable;
import java.util.Arrays;

public class Page
implements Segment<Integer>,
Serializable {
    private static final long serialVersionUID = 97792549823353462L;
    public static final int DEFAULT_PAGE_SIZE = 20;
    private int pageNumber;
    private int pageSize;
    private Order[] orders;
    private Boolean camelCase;
    private String upperOrLowerCase;

    public static Page of(int pageNumber, int pageSize, Boolean camelCase, String upperOrLowerCase) {
        return new Page(pageNumber, pageSize, camelCase, upperOrLowerCase);
    }

    public static Page of(int pageNumber, int pageSize) {
        return new Page(pageNumber, pageSize);
    }

    public Page() {
        this(0, 20);
    }

    public Page(int pageNumber, int pageSize) {
        this.pageNumber = Math.max(pageNumber, 0);
        this.pageSize = pageSize <= 0 ? 20 : pageSize;
    }

    public Page(int pageNumber, int pageSize, Order order) {
        this(pageNumber, pageSize);
        this.orders = new Order[]{order};
    }

    public Page(int pageNumber, int pageSize, Boolean camelCase, String upperOrLowerCase) {
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
        this.camelCase = camelCase;
        this.upperOrLowerCase = upperOrLowerCase;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = Math.max(pageNumber, 0);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize <= 0 ? 20 : pageSize;
    }

    public Order[] getOrders() {
        return this.orders;
    }

    public void setOrder(Order ... orders) {
        this.orders = orders;
    }

    public void addOrder(Order ... orders) {
        this.orders = (Order[])ArrayUtil.append((Object[])this.orders, (Object[])orders);
    }

    public Boolean getCamelCase() {
        return this.camelCase;
    }

    public String getUpperOrLowerCase() {
        return this.upperOrLowerCase;
    }

    public int getStartPosition() {
        return this.getStartIndex();
    }

    public Integer getStartIndex() {
        return PageUtil.getStart((int)this.pageNumber, (int)this.pageSize);
    }

    public int getEndPosition() {
        return this.getEndIndex();
    }

    public Integer getEndIndex() {
        return PageUtil.getEnd((int)this.pageNumber, (int)this.pageSize);
    }

    public int[] getStartEnd() {
        return PageUtil.transToStartEnd((int)this.pageNumber, (int)this.pageSize);
    }

    public String toString() {
        return "Page [page=" + this.pageNumber + ", pageSize=" + this.pageSize + ", order=" + Arrays.toString(this.orders) + "]";
    }
}

