/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.generation.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.springframework.stereotype.Component;

@Component
public class UnzipUtil {
    private static final int BUFFER = 1024;
    private static final String CODING_UTF8 = "UTF-8";
    private static final String CODING_GBK = "GBK";

    public static void decompress(String zipPath, String unzipPath) throws Exception {
        UnzipUtil.decompressFile(new File(zipPath), new File(unzipPath));
    }

    public static void decompressFile(File srcFile, File destFile) throws Exception {
        CheckedInputStream cis = new CheckedInputStream(new FileInputStream(srcFile), new CRC32());
        ZipInputStream zis = new ZipInputStream((InputStream)cis, Charset.forName(CODING_UTF8));
        try {
            zis.getNextEntry().getName();
        }
        catch (Exception e) {
            cis = new CheckedInputStream(new FileInputStream(srcFile), new CRC32());
            zis = new ZipInputStream((InputStream)cis, Charset.forName(CODING_GBK));
        }
        UnzipUtil.decompressZis(destFile, zis);
        zis.close();
    }

    private static void decompressZis(File destFile, ZipInputStream zis) throws Exception {
        ZipEntry entry;
        while ((entry = zis.getNextEntry()) != null) {
            String dir = destFile.getPath() + File.separator + entry.getName();
            File dirFile = new File(dir);
            UnzipUtil.fileProber(dirFile);
            if (entry.isDirectory()) {
                dirFile.mkdirs();
                System.out.println(dirFile.getName());
            } else {
                UnzipUtil.decompressFile(dirFile, zis);
            }
            zis.closeEntry();
        }
    }

    private static void fileProber(File dirFile) {
        File parentFile = dirFile.getParentFile();
        if (!parentFile.exists()) {
            UnzipUtil.fileProber(parentFile);
            parentFile.mkdir();
        }
    }

    private static void decompressFile(File destFile, ZipInputStream zis) throws Exception {
        int count;
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(destFile));
        byte[] data = new byte[1024];
        while ((count = zis.read(data, 0, 1024)) != -1) {
            bos.write(data, 0, count);
        }
        bos.close();
    }
}

