/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.generation.template;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcode.generation.domain.GenerationProcessContentBuilder;
import com.manatee.lowcode.generation.manager.GenerationManager;
import com.manatee.lowcode.generation.template.base.BaseTemplateImpl;
import com.manatee.process.domain.Step;
import com.manatee.process.impl.logic.IfProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ifTemplate")
public class IfTemplate
extends BaseTemplateImpl {
    @Autowired
    private IfProcess ifProcess;
    @Autowired
    private GenerationManager generationManager;

    @Override
    public String getName() {
        return this.ifProcess.getName();
    }

    @Override
    public void bulid(GenerationProcessContentBuilder content, Step step) throws BizException {
        String title = step.getTitle();
        content.getCurrentCodeBuilder().append(content.getIndentationStr()).append("// ").append(title).append("\n");
        content.addResourceSet("ManateeConditionUtil manateeConditionUtil");
        content.addImportSet("com.manatee.process.util.ManateeConditionUtil");
        JSONObject conf = step.getConf();
        JSONArray logicArray = conf.getJSONArray("config");
        for (int i = 0; i < logicArray.size(); ++i) {
            JSONObject aLogic = logicArray.getJSONObject(i);
            String expression = aLogic.getString("expression");
            if (StrUtil.isBlank((CharSequence)expression)) {
                // empty if block
            }
            expression = expression.replaceAll("\"", "\\\\\"");
            if (i == 0) {
                content.getCurrentCodeBuilder().append(content.getIndentationStr()).append("if (manateeConditionUtil.isHappened(\"").append(expression).append("\", content)) { \n");
            } else if ("else".equals(expression)) {
                content.getCurrentCodeBuilder().append(content.getIndentationStr()).append("} else {\n");
            } else {
                content.getCurrentCodeBuilder().append(content.getIndentationStr()).append("} else if (manateeConditionUtil.isHappened(\"").append(expression).append("\", content)) {\n");
            }
            GenerationProcessContentBuilder generate = this.generationManager.generate(aLogic, content);
            content.getCurrentCodeBuilder().append((CharSequence)generate.getCurrentCodeBuilder());
            content.getImportSet().addAll(generate.getImportSet());
            content.getResourceSet().addAll(generate.getResourceSet());
            content.getPrivateFuns().addAll(generate.getPrivateFuns());
            content.getPrivateFunName().addAll(generate.getPrivateFunName());
        }
        content.getCurrentCodeBuilder().append(content.getIndentationStr()).append("}\n");
    }
}

