/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.generation.service;

import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.config.ManateeConfig;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Resource;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GitService {
    protected static Logger LOGGER = LoggerFactory.getLogger(GitService.class);
    public String localPath = "";
    @Resource
    private ManateeConfig manateeConfig;

    public Git cloneFromRemote(String path) {
        com.manatee.config.git.Git gitConfig = this.manateeConfig.getConfigData().getGit();
        String gitlabUserName = gitConfig.getUsername();
        String gitlabPrivateToken = gitConfig.getToken();
        String remotePath = gitConfig.getUrl();
        UsernamePasswordCredentialsProvider usernamePasswordCredentialsProvider = new UsernamePasswordCredentialsProvider(gitlabUserName, gitlabPrivateToken);
        CloneCommand cloneCommand = Git.cloneRepository();
        try {
            Git git = ((CloneCommand)cloneCommand.setURI(remotePath).setBranch("master").setDirectory(new File(path)).setCredentialsProvider((CredentialsProvider)usernamePasswordCredentialsProvider)).call();
            return git;
        }
        catch (Exception e) {
            LOGGER.error("cloneFromRemote error, path:\u3010{}\u3011,gitlabUserName:\u3010{}\u3011, gitlabPrivateToken:\u3010{}\u3011, remotePath:\u3010{}\u3011,e:{}", new Object[]{path, gitlabUserName, gitlabPrivateToken, remotePath, e});
            return null;
        }
    }

    public Git init(File file) throws GitAPIException {
        if (file == null || !file.exists()) {
            return null;
        }
        Git git = Git.init().setDirectory(file).call();
        return git;
    }

    public void createRepo(String path) throws IOException {
        Repository newRepo = FileRepositoryBuilder.create((File)new File(path + "/.git"));
        newRepo.create();
    }

    public void add(File file) throws IOException, GitAPIException {
        Git git = new Git((Repository)new FileRepository(this.localPath + "/.git"));
        git.add().addFilepattern(file.getName()).call();
    }

    public void addAll(Git git) throws IOException, GitAPIException {
        git.add().addFilepattern(".").call();
    }

    public void commit() throws IOException, GitAPIException, JGitInternalException {
        Git git = new Git((Repository)new FileRepository(this.localPath + "/.git"));
        git.commit().setMessage("commit").call();
    }

    public void commit(Git git) throws IOException, GitAPIException, JGitInternalException {
        git.commit().setMessage("commit").call();
    }

    public void pullFromRemoteMaster(String path) throws IOException, GitAPIException {
        com.manatee.config.git.Git gitConfig = this.manateeConfig.getConfigData().getGit();
        String gitlabUserName = gitConfig.getUsername();
        String gitlabPrivateToken = gitConfig.getToken();
        UsernamePasswordCredentialsProvider usernamePasswordCredentialsProvider = new UsernamePasswordCredentialsProvider(gitlabUserName, gitlabPrivateToken);
        Git git = new Git((Repository)new FileRepository(path + "/.git"));
        ((PullCommand)git.pull().setRemoteBranchName("master").setCredentialsProvider((CredentialsProvider)usernamePasswordCredentialsProvider)).call();
    }

    public void push() throws IOException, JGitInternalException, GitAPIException {
        com.manatee.config.git.Git gitConfig = this.manateeConfig.getConfigData().getGit();
        String gitlabUserName = gitConfig.getUsername();
        String gitlabPrivateToken = gitConfig.getToken();
        UsernamePasswordCredentialsProvider usernamePasswordCredentialsProvider = new UsernamePasswordCredentialsProvider(gitlabUserName, gitlabPrivateToken);
        Git git = new Git((Repository)new FileRepository(this.localPath + "/.git"));
        ((PushCommand)git.push().setRemote("origin").setCredentialsProvider((CredentialsProvider)usernamePasswordCredentialsProvider)).call();
    }

    public void push(Git git) throws IOException, JGitInternalException, GitAPIException {
        com.manatee.config.git.Git gitConfig = this.manateeConfig.getConfigData().getGit();
        String gitlabUserName = gitConfig.getUsername();
        String gitlabPrivateToken = gitConfig.getToken();
        String branch = gitConfig.getBranch();
        UsernamePasswordCredentialsProvider usernamePasswordCredentialsProvider = new UsernamePasswordCredentialsProvider(gitlabUserName, gitlabPrivateToken);
        Iterable call = ((PushCommand)git.push().setRemote("origin").setRefSpecs(new RefSpec[]{new RefSpec(branch)}).setCredentialsProvider((CredentialsProvider)usernamePasswordCredentialsProvider)).call();
    }

    public boolean checkBranch(Git git) throws JGitInternalException, GitAPIException {
        com.manatee.config.git.Git gitConfig = this.manateeConfig.getConfigData().getGit();
        String gitlabUserName = gitConfig.getUsername();
        String gitlabPrivateToken = gitConfig.getToken();
        String branch = gitConfig.getBranch();
        String remotePath = gitConfig.getUrl();
        try {
            Collection refList;
            if (StrUtil.isNotEmpty((CharSequence)gitlabUserName) && StrUtil.isNotEmpty((CharSequence)gitlabPrivateToken)) {
                UsernamePasswordCredentialsProvider pro = new UsernamePasswordCredentialsProvider(gitlabUserName, gitlabPrivateToken);
                refList = ((LsRemoteCommand)Git.lsRemoteRepository().setRemote(remotePath).setCredentialsProvider((CredentialsProvider)pro)).call();
            } else {
                refList = Git.lsRemoteRepository().setRemote(remotePath).call();
            }
            ArrayList branchnameList = new ArrayList(4);
            for (Ref ref : refList) {
                String refName = ref.getName();
                if (!refName.startsWith("refs/heads/") || !StrUtil.equals((CharSequence)refName, (CharSequence)("refs/heads/" + branch))) continue;
                return true;
            }
        }
        catch (Exception e) {
            System.out.println("error");
        }
        return false;
    }

    public void createBranch(Git git) throws JGitInternalException, GitAPIException {
        com.manatee.config.git.Git gitConfig = this.manateeConfig.getConfigData().getGit();
        String gitlabUserName = gitConfig.getUsername();
        String gitlabPrivateToken = gitConfig.getToken();
        String branch = gitConfig.getBranch();
        if (StrUtil.isBlank((CharSequence)branch)) {
            return;
        }
        UsernamePasswordCredentialsProvider usernamePasswordCredentialsProvider = new UsernamePasswordCredentialsProvider(gitlabUserName, gitlabPrivateToken);
        Ref ref = git.branchCreate().setName(branch).call();
        git.checkout().setName(branch).call();
        ((PushCommand)git.push().setCredentialsProvider((CredentialsProvider)usernamePasswordCredentialsProvider)).add(ref).call();
        LOGGER.info("createBranch success, branch:\u3010{}\u3011", (Object)branch);
    }

    public void checkoutBranch(Git git) throws JGitInternalException, GitAPIException {
        com.manatee.config.git.Git gitConfig = this.manateeConfig.getConfigData().getGit();
        String branch = gitConfig.getBranch();
        if (StrUtil.isBlank((CharSequence)branch)) {
            return;
        }
        git.checkout().setCreateBranch(true).setName(branch).setStartPoint("origin/" + branch).call();
        LOGGER.info("checkoutBranch success, branch:\u3010{}\u3011", (Object)branch);
    }
}

