/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.process.domain;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.StrSplit;
import com.manatee.common.domain.UnBlockError;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.MapUtils;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcode.util.GlobalConf;
import com.manatee.process.domain.Debug;
import com.manatee.process.domain.ErrorTrace;
import com.manatee.process.domain.ProcessContentBase;
import com.manatee.process.domain.ProcessFileInfo;
import com.manatee.process.domain.Step;
import com.manatee.process.domain.Warn;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ProcessContent
extends ProcessContentBase
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -59520700495138377L;
    private Map<String, Object> header;
    private Map<String, Object> request;
    private Map<String, Object> response;
    private ErrorTrace errorTrace;
    private Debug debug;
    private String isSingle;
    private Warn warn;
    private Step step;
    private InputStream file;
    private String fileName;
    private JSONObject module;
    private JSONObject projectConf;
    private Connection transactionCon;
    private String requestMode;
    private String traceId;
    private List<ProcessFileInfo> files;
    private Map<String, Object> funMap = new HashMap<String, Object>();
    private List<String> modulePath;

    public Long getUserId() {
        Long userId = null;
        Object userIdObj = this.getTempContent("userId");
        if (userIdObj == null) {
            return userId;
        }
        userId = userIdObj instanceof Long ? (Long)userIdObj : Long.valueOf(userIdObj + "");
        return userId;
    }

    public String getCode() {
        return (String)this.getTempContent("lowcodeModule");
    }

    public Long getProjectId() {
        if (this.getTempContent("lowcodeProjectId") != null) {
            return Long.valueOf(String.valueOf(this.getTempContent("lowcodeProjectId")));
        }
        return null;
    }

    public void setCode(String code) {
        this.putTempContent("lowcodeModule", code);
    }

    public void setProjectId(Long projectId) {
        this.putTempContent("lowcodeProjectId", projectId);
    }

    public void putTempContent(String key, Object value) {
        StringBuilder sb = new StringBuilder("tempContext");
        sb.append(StrSplit.P).append(key);
        this.putRequestSubValue(sb.toString(), value);
    }

    public void setTempConf(JSONObject tempConf) {
        if (this.step == null) {
            return;
        }
        this.step.setTempConf(tempConf);
    }

    public void removeTempConf() {
        if (this.step == null) {
            return;
        }
        this.step.removeTempConf();
    }

    public void removeTempContent(String key) {
        Map temp = (Map)this.getRequest("tempContext");
        if (temp == null) {
            return;
        }
        temp.remove(key);
    }

    public Object getTempContent(String key) {
        StringBuilder sb = new StringBuilder("tempContext");
        sb.append(StrSplit.P).append(key);
        return this.getRequestSubValue(sb.toString());
    }

    public JSONObject getStepConf() {
        if (this.step == null) {
            return null;
        }
        return this.step.getConf();
    }

    @Override
    public String getStepConfString(String key) {
        return (String)this.getStepConf(key);
    }

    public Object getStepConf(String key) {
        JSONObject conf = this.getStepConf();
        if (conf == null) {
            return null;
        }
        Object value = conf.get((Object)key);
        if (value != null) {
            return value;
        }
        if (this.projectConf != null && (value = this.projectConf.get((Object)key)) != null) {
            return value;
        }
        if (this.step == null || StringUtil.isBlank(this.step.getName())) {
            return null;
        }
        return GlobalConf.getConf(this.step.getName(), key);
    }

    public Map<String, Object> getRequest() {
        if (this.request == null) {
            this.request = new LinkedHashMap<String, Object>();
        }
        return this.request;
    }

    public Map<String, Object> getResponse() {
        if (this.response == null) {
            this.response = new LinkedHashMap<String, Object>();
        }
        return this.response;
    }

    public Object getRequest(String key) {
        Map<String, Object> extMap = this.getRequest();
        return extMap.get(key);
    }

    public Object getResponse(String key) {
        Map<String, Object> extMap = this.getResponse();
        return extMap.get(key);
    }

    public void putModule(String key, Object value) {
        if (this.module == null) {
            this.module = new JSONObject();
        }
        this.module.put(key, value);
    }

    public Object getModule(String key) {
        if (this.module == null) {
            return null;
        }
        return this.module.get((Object)key);
    }

    public void putResponse(String key, Object value) {
        if (this.response == null) {
            this.response = new LinkedHashMap<String, Object>();
        }
        this.putSubVal(this.response, key, value);
    }

    public Object getValue(String key) {
        return this.getValue(key, null);
    }

    public Object getValue(String key, JSONObject conf) {
        Object value = null;
        if (key == null) {
            return null;
        }
        Object value1 = this.getTempValue(key);
        if (value1 != null) {
            return value1;
        }
        if (conf == null) {
            conf = this.getStepConf();
        }
        if (conf == null) {
            conf = new JSONObject();
        }
        return this.getValueWithInside(key, conf);
    }

    public Object getValueInside(String key) {
        return this.getValueInside(key, null);
    }

    public Object getValueInside(String key, JSONObject conf) {
        if (key == null) {
            return null;
        }
        if (conf == null) {
            conf = this.getStepConf();
        }
        if (conf == null) {
            conf = new JSONObject();
        }
        return this.getValueWithInside(key, conf);
    }

    private Object getValueWithInside(String key, JSONObject conf) {
        Object value = null;
        String requestStr = "request.";
        String responseStr = "response.";
        String headerStr = "requestHeader.";
        if (key.indexOf(requestStr) != -1) {
            String newKey = key.replace(requestStr, "");
            return this.getRequestSubValueWithInside(newKey);
        }
        if (key.indexOf(responseStr) != -1) {
            String newKey = key.replace(responseStr, "");
            return this.getResponseSubValueWithInside(newKey);
        }
        if (key.indexOf(headerStr) != -1) {
            String newKey = key.replace(headerStr, "");
            return this.getHeaderSubValueWithInside(newKey);
        }
        String valueFrom = conf.getString("valueFrom");
        if ("request".equals(valueFrom)) {
            return this.getRequestSubValueWithInside(key);
        }
        if ("response".equals(valueFrom)) {
            return this.getResponseSubValueWithInside(key);
        }
        value = this.getRequestSubValueWithInside(key);
        if (value == null) {
            value = this.getResponseSubValueWithInside(key);
        }
        if (value == null) {
            value = this.getHeaderSubValueWithInside(key);
        }
        return value;
    }

    public Object getResponseSubValue(String key) {
        return this.getSubValue(this.response, key);
    }

    public Object getRequestSubValue(String key) {
        return this.getSubValue(this.request, key);
    }

    private Object getResponseSubValueWithInside(String key) {
        if (this.response == null) {
            return null;
        }
        Object value = this.getResponseSubValue(key);
        if (value != null) {
            return value;
        }
        return this.getContentInside(key, this.response, this);
    }

    private Object getHeaderSubValueWithInside(String key) {
        if (this.header == null) {
            return null;
        }
        Object value = this.getSubValue(this.header, key);
        if (value != null) {
            return value;
        }
        return this.getContentInside(key, this.header, this);
    }

    private Object getRequestSubValueWithInside(String key) {
        if (this.request == null) {
            return null;
        }
        Object value = this.getRequestSubValue(key);
        if (value != null) {
            return value;
        }
        value = this.getContentInside(key, this.request, this);
        if (value == null) {
            Map temp = (Map)this.request.get("tempContext");
            value = this.getSubValue(temp, key);
        }
        return value;
    }

    public void putResponseSubValue(String key, Object value) {
        Object oldValue;
        if (this.isExistNotReplace() && (oldValue = this.getResponseSubValue(key)) != null) {
            return;
        }
        if (this.response == null) {
            this.response = new LinkedHashMap<String, Object>();
        }
        MapUtils.putSubValue(this.response, key, value);
    }

    public void putRequestSubValue(String key, Object value) {
        Object oldValue;
        if (this.isExistNotReplace() && (oldValue = this.getRequestSubValue(key)) != null) {
            return;
        }
        if (this.request == null) {
            this.request = new LinkedHashMap<String, Object>();
        }
        MapUtils.putSubValue(this.request, key, value);
    }

    public void putHeader(String key, Object value) {
        if (this.header == null) {
            this.header = new LinkedHashMap<String, Object>();
        }
        this.putSubVal(this.header, key, value);
    }

    public void putRequest(String key, Object value) {
        if (this.request == null) {
            this.request = new LinkedHashMap<String, Object>();
        }
        this.putSubVal(this.request, key, value);
    }

    public Object getValueFromRequestOrResponse(String key) {
        Object value = this.getRequestSubValue(key);
        if (value == null) {
            value = this.getResponseSubValue(key);
        }
        return value;
    }

    public void putRequest(Map<String, Object> map) {
        if (map == null || map.size() == 0) {
            return;
        }
        HashMap<String, Object> newMap = new HashMap();
        if (this.isExistNotReplace()) {
            for (Map.Entry<String, Object> aMap : map.entrySet()) {
                String key = aMap.getKey();
                Object oldValue = this.getRequestSubValue(key);
                if (oldValue != null) continue;
                newMap.put(key, aMap.getValue());
            }
        } else {
            newMap = map;
        }
        this.request = this.putValue(this.request, newMap);
    }

    public void removeRequest(String key) {
        if (this.request == null) {
            return;
        }
        this.request.remove(key);
    }

    public void putResponse(Map<String, Object> map) {
        if (map == null || map.size() == 0) {
            return;
        }
        HashMap<String, Object> newMap = new HashMap();
        if (this.isExistNotReplace()) {
            for (Map.Entry<String, Object> aMap : map.entrySet()) {
                String key = aMap.getKey();
                Object oldValue = this.getResponseSubValue(key);
                if (oldValue != null) continue;
                newMap.put(key, aMap.getValue());
            }
        } else {
            newMap = map;
        }
        this.response = this.putValue(this.response, newMap);
    }

    public void putValueToContent(Object value) {
        JSONObject conf = this.step.getConf();
        String putKey = null;
        if (conf.containsKey((Object)"putKey")) {
            putKey = conf.getString("putKey");
        }
        this.putValueToContent(putKey, value, conf);
    }

    public void putValueToContent(String putKey, Object value, JSONObject conf) {
        if (putKey == null) {
            return;
        }
        if (!conf.containsKey((Object)"directPut") || !conf.getBoolean("directPut").booleanValue()) {
            this.putRequestSubValue(putKey, value);
        } else {
            this.putResponseSubValue(putKey, value);
        }
    }

    private boolean isExistNotReplace() {
        Object existNotReplace = this.getStepConf("existNotReplace");
        return Boolean.TRUE.equals(existNotReplace);
    }

    @Override
    public String toString() {
        JSONObject value = new JSONObject();
        try {
            JSONObject va;
            if (this.request != null) {
                va = this.formatContent(this.request);
                value.put("request", (Object)va);
            }
            if (this.response != null) {
                va = this.formatContent(this.response);
                value.put("response", (Object)va);
            }
            value.put("stepName", (Object)this.step.getName());
            value.put("stepConf", (Object)this.step.getConf());
        }
        catch (Throwable e) {
            System.out.println(e.getMessage());
        }
        return value.toString();
    }

    private JSONObject formatContent(Map<String, Object> request) {
        JSONObject re = new JSONObject();
        for (Map.Entry<String, Object> map : request.entrySet()) {
            Object values = map.getValue();
            if (!this.needPutType(values).booleanValue()) continue;
            if (values != null && (values + "").length() > 100) {
                String subStr = (values + "").substring(0, 100) + "\u2026\u2026";
                re.put(map.getKey(), (Object)subStr);
                continue;
            }
            re.put(map.getKey(), map.getValue());
        }
        return re;
    }

    public Boolean needPutType(Object value) {
        if (value instanceof String) {
            return true;
        }
        if (value instanceof Long) {
            return true;
        }
        return false;
    }

    public BizException getException() {
        if (this.errorTrace == null) {
            return null;
        }
        return this.errorTrace.getException();
    }

    public void addException(Throwable exception) {
        if (this.errorTrace == null) {
            this.errorTrace = new ErrorTrace();
        }
        this.errorTrace.addException(this.step, exception);
    }

    public void addUnBlockErrorList(List<UnBlockError> unBlockErrorList) {
        if (this.errorTrace == null) {
            this.errorTrace = new ErrorTrace();
        }
        this.errorTrace.addUnBlockErrorList(unBlockErrorList);
    }

    public void setInterruptLevel(Integer interruptLevel) {
        if (this.errorTrace == null) {
            this.errorTrace = new ErrorTrace();
        }
        this.errorTrace.setInterruptLevel(interruptLevel);
    }

    public int getInterruptLevel() {
        if (this.errorTrace == null) {
            return 0;
        }
        return this.errorTrace.getInterruptLevel();
    }

    public ErrorTrace getErrorTrace() {
        if (this.errorTrace == null) {
            this.errorTrace = new ErrorTrace();
        }
        return this.errorTrace;
    }

    public boolean getIsSingle() {
        if (this.getTempContent("isSingle") != null) {
            return Boolean.parseBoolean(this.getTempContent("isSingle").toString());
        }
        return false;
    }

    public List<String> getModulePathList() {
        return this.modulePath;
    }

    public void addModulePath(String modulePath) {
        if (this.modulePath == null) {
            this.modulePath = new ArrayList<String>();
        }
        this.modulePath.add(modulePath);
    }

    public void addAllModulePath(List<String> modulePathList) {
        if (this.modulePath == null) {
            this.modulePath = new ArrayList<String>();
        } else {
            this.modulePath.clear();
        }
        this.modulePath.addAll(modulePathList);
    }

    public void removeLastModulePath() {
        if (this.modulePath != null && this.modulePath.size() > 0) {
            this.modulePath.remove(this.modulePath.size() - 1);
        }
    }

    public Map<String, Object> getHeader() {
        return this.header;
    }

    public Debug getDebug() {
        return this.debug;
    }

    public Warn getWarn() {
        return this.warn;
    }

    public Step getStep() {
        return this.step;
    }

    public InputStream getFile() {
        return this.file;
    }

    public String getFileName() {
        return this.fileName;
    }

    public JSONObject getModule() {
        return this.module;
    }

    public JSONObject getProjectConf() {
        return this.projectConf;
    }

    public Connection getTransactionCon() {
        return this.transactionCon;
    }

    public String getRequestMode() {
        return this.requestMode;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public List<ProcessFileInfo> getFiles() {
        return this.files;
    }

    public Map<String, Object> getFunMap() {
        return this.funMap;
    }

    public List<String> getModulePath() {
        return this.modulePath;
    }

    public void setHeader(Map<String, Object> header) {
        this.header = header;
    }

    public void setRequest(Map<String, Object> request) {
        this.request = request;
    }

    public void setResponse(Map<String, Object> response) {
        this.response = response;
    }

    public void setErrorTrace(ErrorTrace errorTrace) {
        this.errorTrace = errorTrace;
    }

    public void setDebug(Debug debug) {
        this.debug = debug;
    }

    public void setIsSingle(String isSingle) {
        this.isSingle = isSingle;
    }

    public void setWarn(Warn warn) {
        this.warn = warn;
    }

    public void setStep(Step step) {
        this.step = step;
    }

    public void setFile(InputStream file) {
        this.file = file;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setModule(JSONObject module) {
        this.module = module;
    }

    public void setProjectConf(JSONObject projectConf) {
        this.projectConf = projectConf;
    }

    public void setTransactionCon(Connection transactionCon) {
        this.transactionCon = transactionCon;
    }

    public void setRequestMode(String requestMode) {
        this.requestMode = requestMode;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public void setFiles(List<ProcessFileInfo> files) {
        this.files = files;
    }

    public void setFunMap(Map<String, Object> funMap) {
        this.funMap = funMap;
    }

    public void setModulePath(List<String> modulePath) {
        this.modulePath = modulePath;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProcessContent)) {
            return false;
        }
        ProcessContent other = (ProcessContent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Object> this$header = this.getHeader();
        Map<String, Object> other$header = other.getHeader();
        if (this$header == null ? other$header != null : !((Object)this$header).equals(other$header)) {
            return false;
        }
        Map<String, Object> this$request = this.getRequest();
        Map<String, Object> other$request = other.getRequest();
        if (this$request == null ? other$request != null : !((Object)this$request).equals(other$request)) {
            return false;
        }
        Map<String, Object> this$response = this.getResponse();
        Map<String, Object> other$response = other.getResponse();
        if (this$response == null ? other$response != null : !((Object)this$response).equals(other$response)) {
            return false;
        }
        ErrorTrace this$errorTrace = this.getErrorTrace();
        ErrorTrace other$errorTrace = other.getErrorTrace();
        if (this$errorTrace == null ? other$errorTrace != null : !((Object)this$errorTrace).equals(other$errorTrace)) {
            return false;
        }
        Debug this$debug = this.getDebug();
        Debug other$debug = other.getDebug();
        if (this$debug == null ? other$debug != null : !this$debug.equals(other$debug)) {
            return false;
        }
        if (this.getIsSingle() != other.getIsSingle()) {
            return false;
        }
        Warn this$warn = this.getWarn();
        Warn other$warn = other.getWarn();
        if (this$warn == null ? other$warn != null : !((Object)this$warn).equals(other$warn)) {
            return false;
        }
        Step this$step = this.getStep();
        Step other$step = other.getStep();
        if (this$step == null ? other$step != null : !((Object)this$step).equals(other$step)) {
            return false;
        }
        InputStream this$file = this.getFile();
        InputStream other$file = other.getFile();
        if (this$file == null ? other$file != null : !this$file.equals(other$file)) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        JSONObject this$module = this.getModule();
        JSONObject other$module = other.getModule();
        if (this$module == null ? other$module != null : !this$module.equals(other$module)) {
            return false;
        }
        JSONObject this$projectConf = this.getProjectConf();
        JSONObject other$projectConf = other.getProjectConf();
        if (this$projectConf == null ? other$projectConf != null : !this$projectConf.equals(other$projectConf)) {
            return false;
        }
        Connection this$transactionCon = this.getTransactionCon();
        Connection other$transactionCon = other.getTransactionCon();
        if (this$transactionCon == null ? other$transactionCon != null : !this$transactionCon.equals(other$transactionCon)) {
            return false;
        }
        String this$requestMode = this.getRequestMode();
        String other$requestMode = other.getRequestMode();
        if (this$requestMode == null ? other$requestMode != null : !this$requestMode.equals(other$requestMode)) {
            return false;
        }
        String this$traceId = this.getTraceId();
        String other$traceId = other.getTraceId();
        if (this$traceId == null ? other$traceId != null : !this$traceId.equals(other$traceId)) {
            return false;
        }
        List<ProcessFileInfo> this$files = this.getFiles();
        List<ProcessFileInfo> other$files = other.getFiles();
        if (this$files == null ? other$files != null : !((Object)this$files).equals(other$files)) {
            return false;
        }
        Map<String, Object> this$funMap = this.getFunMap();
        Map<String, Object> other$funMap = other.getFunMap();
        if (this$funMap == null ? other$funMap != null : !((Object)this$funMap).equals(other$funMap)) {
            return false;
        }
        List<String> this$modulePath = this.getModulePath();
        List<String> other$modulePath = other.getModulePath();
        return !(this$modulePath == null ? other$modulePath != null : !((Object)this$modulePath).equals(other$modulePath));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ProcessContent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Object> $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : ((Object)$header).hashCode());
        Map<String, Object> $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
        Map<String, Object> $response = this.getResponse();
        result = result * 59 + ($response == null ? 43 : ((Object)$response).hashCode());
        ErrorTrace $errorTrace = this.getErrorTrace();
        result = result * 59 + ($errorTrace == null ? 43 : ((Object)$errorTrace).hashCode());
        Debug $debug = this.getDebug();
        result = result * 59 + ($debug == null ? 43 : $debug.hashCode());
        result = result * 59 + (this.getIsSingle() ? 79 : 97);
        Warn $warn = this.getWarn();
        result = result * 59 + ($warn == null ? 43 : ((Object)$warn).hashCode());
        Step $step = this.getStep();
        result = result * 59 + ($step == null ? 43 : ((Object)$step).hashCode());
        InputStream $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : $file.hashCode());
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        JSONObject $module = this.getModule();
        result = result * 59 + ($module == null ? 43 : $module.hashCode());
        JSONObject $projectConf = this.getProjectConf();
        result = result * 59 + ($projectConf == null ? 43 : $projectConf.hashCode());
        Connection $transactionCon = this.getTransactionCon();
        result = result * 59 + ($transactionCon == null ? 43 : $transactionCon.hashCode());
        String $requestMode = this.getRequestMode();
        result = result * 59 + ($requestMode == null ? 43 : $requestMode.hashCode());
        String $traceId = this.getTraceId();
        result = result * 59 + ($traceId == null ? 43 : $traceId.hashCode());
        List<ProcessFileInfo> $files = this.getFiles();
        result = result * 59 + ($files == null ? 43 : ((Object)$files).hashCode());
        Map<String, Object> $funMap = this.getFunMap();
        result = result * 59 + ($funMap == null ? 43 : ((Object)$funMap).hashCode());
        List<String> $modulePath = this.getModulePath();
        result = result * 59 + ($modulePath == null ? 43 : ((Object)$modulePath).hashCode());
        return result;
    }
}

