/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.manager;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.manatee.common.util.CollectionUtils;
import com.manatee.common.util.JSONUtils;
import com.manatee.common.util.tool.http.HttpRequest;
import com.manatee.common.util.tool.http.HttpUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

@Component
public class ModuleResultContrastManager {
    private static Log log = LogFactory.getLog(ModuleResultContrastManager.class);

    public static Map<String, JSONObject> httpRequestForModuleList(String urlPrefix, List moduleList) {
        HashMap<String, JSONObject> result = new HashMap<String, JSONObject>();
        JSONObject responseFailJson = new JSONObject();
        for (Object object : moduleList) {
            String response;
            JSONObject getParamJson = new JSONObject();
            JSONObject postParamJson = new JSONObject();
            JSONObject mdouleJson = JSONObject.parseObject((String)JSON.toJSONString(object));
            ModuleResultContrastManager.assembleParam(mdouleJson, getParamJson, postParamJson);
            String url = urlPrefix + "?lowcodeProjectId=" + mdouleJson.get((Object)"projectId") + "&lowcodeModule=" + mdouleJson.get((Object)"code");
            try {
                response = "GET".equals(mdouleJson.getString("requestMode")) ? HttpUtil.get(url, (Map<String, Object>)getParamJson) : HttpRequest.post(url).body(postParamJson.toJSONString()).execute().body();
            }
            catch (Exception e) {
                log.error((Object)("[ModuleResultContrastManager.httpRequestForModuleList]_" + url + ",error:" + e.getMessage()));
                responseFailJson.put("msg", (Object)("\u56de\u5f52\u8bf7\u6c42\u53d1\u751f\u5f02\u5e38: " + e.getMessage()));
                response = responseFailJson.toJSONString();
                result.put(mdouleJson.getString("id"), JSONObject.parseObject((String)response, (Feature[])new Feature[]{Feature.OrderedField}));
            }
            if (JSONUtils.isJson(response)) {
                JSONObject jsonObject = JSONObject.parseObject((String)response, (Feature[])new Feature[]{Feature.OrderedField});
                jsonObject.remove((Object)"traceId");
                result.put(mdouleJson.getString("id"), jsonObject);
                continue;
            }
            responseFailJson.put("msg", (Object)"\u56de\u5f52\u8bf7\u6c42\u7ed3\u679c\u4e0d\u662fjson");
            response = responseFailJson.toJSONString();
            result.put(mdouleJson.getString("id"), JSONObject.parseObject((String)response, (Feature[])new Feature[]{Feature.OrderedField}));
        }
        return result;
    }

    private static void assembleParam(JSONObject mdouleJson, JSONObject getParamJson, JSONObject postParamJson) {
        JSONObject params = mdouleJson.getJSONObject("params");
        if (params != null) {
            JSONObject postJson;
            JSONArray getJsonArr = params.getJSONArray("get");
            if (CollectionUtils.isNotEmpty(getJsonArr)) {
                for (Object o : getJsonArr) {
                    JSONObject oJson = (JSONObject)o;
                    getParamJson.put(oJson.getString("KEY"), oJson.get((Object)"VALUE"));
                }
            }
            if ((postJson = params.getJSONObject("post")) != null) {
                postParamJson.putAll((Map)params.getJSONObject("post"));
            }
        }
    }

    public static void main(String[] args) {
        ArrayList<JSONObject> moduleList = new ArrayList<JSONObject>();
        moduleList.add(new JSONObject(){
            {
                this.put("id", 324);
                this.put("code", "mysqlQuery");
                this.put("projectId", 35);
                this.put("requestMode", "GET");
                this.put("params", "{\"get\":[{\"KEY\":\"pageNum\",\"VALUE\":\"1\",\"DESC\":\"\",\"key\":\"1626261376890\"},{\"KEY\":\"pageSize\",\"VALUE\":\"1\",\"DESC\":\"\",\"key\":\"1626261379119\"},{\"KEY\":\"projectId\",\"VALUE\":\"35\",\"DESC\":\"\",\"key\":\"1627105423259\"},{\"KEY\":\"\",\"VALUE\":\"\",\"DESC\":\"\",\"key\":\"0.49630793260524464\"}],\"post\":{},\"paramVerify\":{\"pageNum\":{\"required\":false},\"pageSize\":{\"required\":false},\"projectId\":{\"required\":false},\"\":{\"required\":false}},\"host\":\"http://dev.manateeai.com\"}");
            }
        });
        moduleList.add(new JSONObject(){
            {
                this.put("id", 226);
                this.put("code", "helloWorld");
                this.put("projectId", 35);
                this.put("requestMode", "POST");
                this.put("params", "{\"get\":[{\"KEY\":\"desc\",\"VALUE\":\"hello\",\"DESC\":\"\",\"key\":\"1620643898750\",\"paramType\":\"Number\",\"required\":false}],\"post\":{\"list\":[{\"a\":1}],\"msg\":\"aaa\"},\"paramVerify\":{\"list\":{\"required\":false},\"msg\":{\"required\":false}},\"host\":\"http://dev.manateeai.com\"}");
            }
        });
        Map<String, JSONObject> map = ModuleResultContrastManager.httpRequestForModuleList("http://127.0.0.1:8104/biz/customizeModule.do", moduleList);
        System.out.println(JSONObject.toJSONString(map));
    }
}

