/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.util.tool.json;

import com.manatee.common.util.tool.core.convert.ConvertException;
import com.manatee.common.util.tool.core.getter.OptNullBasicTypeFromObjectGetter;
import com.manatee.common.util.tool.json.JSON;
import com.manatee.common.util.tool.json.JSONArray;
import com.manatee.common.util.tool.json.JSONConfig;
import com.manatee.common.util.tool.json.JSONConverter;
import com.manatee.common.util.tool.json.JSONNull;
import com.manatee.common.util.tool.json.JSONObject;
import com.manatee.common.util.tool.json.JSONUtil;

public interface JSONGetter<K>
extends OptNullBasicTypeFromObjectGetter<K> {
    public JSONConfig getConfig();

    default public boolean isNull(K key) {
        return JSONNull.NULL.equals(this.getObj(key));
    }

    default public String getStrEscaped(K key) {
        return this.getStrEscaped(key, null);
    }

    default public String getStrEscaped(K key, String defaultValue) {
        return JSONUtil.escape(this.getStr(key, defaultValue));
    }

    default public JSONArray getJSONArray(K key) {
        Object object = this.getObj(key);
        if (null == object) {
            return null;
        }
        if (object instanceof JSON) {
            return (JSONArray)object;
        }
        return new JSONArray(object, this.getConfig());
    }

    default public JSONObject getJSONObject(K key) {
        Object object = this.getObj(key);
        if (null == object) {
            return null;
        }
        if (object instanceof JSON) {
            return (JSONObject)object;
        }
        return new JSONObject(object, this.getConfig());
    }

    default public <T> T getBean(K key, Class<T> beanType) {
        JSONObject obj = this.getJSONObject(key);
        return null == obj ? null : (T)obj.toBean(beanType);
    }

    default public <T> T get(K key, Class<T> type) throws ConvertException {
        return this.get(key, type, false);
    }

    default public <T> T get(K key, Class<T> type, boolean ignoreError) throws ConvertException {
        Object value = this.getObj(key);
        if (null == value) {
            return null;
        }
        return JSONConverter.jsonConvert(type, value, ignoreError);
    }
}

