/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.util.tool.core.net;

import com.manatee.common.util.tool.core.collection.ListUtil;
import com.manatee.common.util.tool.core.convert.Convert;
import com.manatee.common.util.tool.core.lang.Assert;
import com.manatee.common.util.tool.core.lang.Validator;
import com.manatee.common.util.tool.core.net.MaskBit;
import com.manatee.common.util.tool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Ipv4Util {
    public static final String IP_SPLIT_MARK = "-";
    public static final String IP_MASK_SPLIT_MARK = "/";
    public static final int IP_MASK_MAX = 32;

    public static String formatIpBlock(String ip, String mask) {
        return ip + IP_MASK_SPLIT_MARK + Ipv4Util.getMaskBitByMask(mask);
    }

    public static List<String> list(String ipRange, boolean isAll) {
        if (ipRange.contains(IP_SPLIT_MARK)) {
            String[] range = StrUtil.split((CharSequence)ipRange, IP_SPLIT_MARK);
            return Ipv4Util.list(range[0], range[1]);
        }
        if (ipRange.contains(IP_MASK_SPLIT_MARK)) {
            String[] param = StrUtil.split((CharSequence)ipRange, IP_MASK_SPLIT_MARK);
            return Ipv4Util.list(param[0], Integer.parseInt(param[1]), isAll);
        }
        return ListUtil.toList(ipRange);
    }

    public static List<String> list(String ip, int maskBit, boolean isAll) {
        if (maskBit == 32) {
            ArrayList<String> list = new ArrayList<String>();
            if (isAll) {
                list.add(ip);
            }
            return list;
        }
        String startIp = Ipv4Util.getBeginIpStr(ip, maskBit);
        String endIp = Ipv4Util.getEndIpStr(ip, maskBit);
        if (isAll) {
            return Ipv4Util.list(startIp, endIp);
        }
        int lastDotIndex = startIp.lastIndexOf(46) + 1;
        startIp = StrUtil.subPre(startIp, lastDotIndex) + (Integer.parseInt(Objects.requireNonNull(StrUtil.subSuf(startIp, lastDotIndex))) + 1);
        lastDotIndex = endIp.lastIndexOf(46) + 1;
        endIp = StrUtil.subPre(endIp, lastDotIndex) + (Integer.parseInt(Objects.requireNonNull(StrUtil.subSuf(endIp, lastDotIndex))) - 1);
        return Ipv4Util.list(startIp, endIp);
    }

    public static List<String> list(String ipFrom, String ipTo) {
        int[] ipf = Convert.convert(int[].class, (Object)StrUtil.splitToArray(ipFrom, '.'));
        int[] ipt = Convert.convert(int[].class, (Object)StrUtil.splitToArray(ipTo, '.'));
        ArrayList<String> ips = new ArrayList<String>();
        for (int a = ipf[0]; a <= ipt[0]; ++a) {
            for (int b = a == ipf[0] ? ipf[1] : 0; b <= (a == ipt[0] ? ipt[1] : 255); ++b) {
                for (int c = b == ipf[1] ? ipf[2] : 0; c <= (b == ipt[1] ? ipt[2] : 255); ++c) {
                    for (int d = c == ipf[2] ? ipf[3] : 0; d <= (c == ipt[2] ? ipt[3] : 255); ++d) {
                        ips.add(a + "." + b + "." + c + "." + d);
                    }
                }
            }
        }
        return ips;
    }

    public static String longToIpv4(long longIP) {
        StringBuilder sb = StrUtil.builder();
        sb.append(longIP >> 24 & 0xFFL);
        sb.append('.');
        sb.append(longIP >> 16 & 0xFFL);
        sb.append('.');
        sb.append(longIP >> 8 & 0xFFL);
        sb.append('.');
        sb.append(longIP & 0xFFL);
        return sb.toString();
    }

    public static long ipv4ToLong(String strIP) {
        Validator.validateIpv4(strIP, "Invalid IPv4 address!");
        long[] ip = Convert.convert(long[].class, StrUtil.split((CharSequence)strIP, '.'));
        return (ip[0] << 24) + (ip[1] << 16) + (ip[2] << 8) + ip[3];
    }

    public static String getBeginIpStr(String ip, int maskBit) {
        return Ipv4Util.longToIpv4(Ipv4Util.getBeginIpLong(ip, maskBit));
    }

    private static Long getBeginIpLong(String ip, int maskBit) {
        return Ipv4Util.ipv4ToLong(ip) & Ipv4Util.ipv4ToLong(Ipv4Util.getMaskByMaskBit(maskBit));
    }

    public static String getEndIpStr(String ip, int maskBit) {
        return Ipv4Util.longToIpv4(Ipv4Util.getEndIpLong(ip, maskBit));
    }

    public static int getMaskBitByMask(String mask) {
        int inetmask = 0;
        for (String part : StrUtil.split((CharSequence)mask, '.')) {
            StringBuffer sbf = Ipv4Util.toBin(Integer.parseInt(part));
            String str = sbf.reverse().toString();
            int count = 0;
            for (int i = 0; i < str.length() && (i = str.indexOf(49, i)) != -1; ++i) {
                ++count;
            }
            inetmask += count;
        }
        return inetmask;
    }

    public static int countByMaskBit(int maskBit, boolean isAll) {
        if (!(isAll || maskBit > 0 && maskBit < 32)) {
            return 0;
        }
        int count = (int)Math.pow(2.0, 32 - maskBit);
        return isAll ? count : count - 2;
    }

    public static String getMaskByMaskBit(int maskBit) {
        return MaskBit.get(maskBit);
    }

    public static String getMaskByIpRange(String fromIp, String toIp) {
        long toIpLong = Ipv4Util.ipv4ToLong(toIp);
        long fromIpLong = Ipv4Util.ipv4ToLong(fromIp);
        Assert.isTrue(fromIpLong < toIpLong, "to IP must be greater than from IP!", new Object[0]);
        String[] fromIpSplit = StrUtil.splitToArray(fromIp, '.');
        String[] toIpSplit = StrUtil.splitToArray(toIp, '.');
        StringBuilder mask = new StringBuilder();
        for (int i = 0; i < toIpSplit.length; ++i) {
            mask.append(255 - Integer.parseInt(toIpSplit[i]) + Integer.parseInt(fromIpSplit[i])).append('.');
        }
        return mask.substring(0, mask.length() - 1);
    }

    public static int countByIpRange(String fromIp, String toIp) {
        long toIpLong = Ipv4Util.ipv4ToLong(toIp);
        long fromIpLong = Ipv4Util.ipv4ToLong(fromIp);
        if (fromIpLong > toIpLong) {
            throw new IllegalArgumentException("to IP must be greater than from IP!");
        }
        int count = 1;
        int[] fromIpSplit = StrUtil.split((CharSequence)fromIp, '.').stream().mapToInt(Integer::parseInt).toArray();
        int[] toIpSplit = StrUtil.split((CharSequence)toIp, '.').stream().mapToInt(Integer::parseInt).toArray();
        for (int i = fromIpSplit.length - 1; i >= 0; --i) {
            count = (int)((double)count + (double)(toIpSplit[i] - fromIpSplit[i]) * Math.pow(256.0, fromIpSplit.length - i - 1));
        }
        return count;
    }

    private static Long getEndIpLong(String ip, int maskBit) {
        return Ipv4Util.getBeginIpLong(ip, maskBit) + (Ipv4Util.ipv4ToLong(Ipv4Util.getMaskByMaskBit(maskBit)) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private static StringBuffer toBin(int x) {
        StringBuffer result = new StringBuffer();
        result.append(x % 2);
        x /= 2;
        while (x > 0) {
            result.append(x % 2);
            x /= 2;
        }
        return result;
    }
}

