/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.webservice.type;

import com.manatee.common.util.StringUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.domain.ProcessContent;
import com.manatee.webservice.type.BaseWebServiceClient;
import javax.annotation.Resource;
import javax.xml.namespace.QName;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.jaxws.endpoint.dynamic.JaxWsDynamicClientFactory;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.springframework.stereotype.Component;

@Component
public class SoapClient
extends BaseWebServiceClient {
    @Resource
    private VariableUtil variableUtil;
    JaxWsDynamicClientFactory factory = JaxWsDynamicClientFactory.newInstance();

    public void handle(ProcessContent content) throws Exception {
        String url = this.getUrl(content);
        Client client = this.initClient(url);
        Object[] params = this.getParams(content, url);
        Object obj = this.invoke(content, client, params);
        this.handleData(content, obj);
    }

    private Client initClient(String url) {
        Client client = this.factory.createClient(url);
        HTTPConduit conduit = (HTTPConduit)client.getConduit();
        HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
        httpClientPolicy.setConnectionTimeout(2000L);
        httpClientPolicy.setAllowChunking(false);
        httpClientPolicy.setReceiveTimeout(100000L);
        conduit.setClient(httpClientPolicy);
        return client;
    }

    private Object invoke(ProcessContent content, Client client, Object[] params) throws Exception {
        Object data;
        Object[] objects;
        String namespace = this.getNamespace(content);
        String method = this.variableUtil.calVarInConf(content, "method");
        if (StringUtil.isNotBlank((String)namespace)) {
            QName q = new QName(namespace, method);
            objects = client.invoke(q, params);
        } else {
            objects = client.invoke(method, params);
        }
        if (objects.length > 0 && (data = objects[0]) != null) {
            return data;
        }
        return null;
    }

    private String getNamespace(ProcessContent content) {
        String namespace = content.getStepConfString("namespace");
        if (StringUtil.isNotBlank((String)namespace)) {
            return namespace;
        }
        return null;
    }
}

