/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.quartz;

import com.alibaba.fastjson.JSONObject;
import com.manatee.lowcode.domain.ModularityRequest;
import com.manatee.lowcode.domain.ModularityResult;
import com.manatee.lowcode.web.manager.ModularityManager;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ModularityQuartzJob {
    private static final Logger log = LoggerFactory.getLogger(ModularityQuartzJob.class);
    @Autowired
    private ModularityManager modularityManager;

    public ModularityResult modularityJobHandler(Long projectId, String code, Map<String, Object> params) throws Exception {
        ModularityRequest modularityRequest = new ModularityRequest();
        modularityRequest.setProjectId(projectId);
        modularityRequest.setCode(code);
        modularityRequest.setParams(params);
        String traceId = MDC.get((String)"traceId");
        modularityRequest.setTraceId(traceId);
        log.info("quartz job \u5f00\u59cb\uff0cprojectId\uff1a{}\uff0ccode\uff1a{} params\uff1a{}, traceId:{}", new Object[]{projectId, code, params, traceId});
        ModularityResult modularityResult = this.modularityManager.executionModule(modularityRequest);
        log.info("quartz job \u7ed3\u675f\uff1a{}, traceId:{}", (Object)JSONObject.toJSONString((Object)modularityResult), (Object)traceId);
        return modularityResult;
    }
}

