/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.process.store.mysql;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.process.IProcess;
import com.manatee.process.ProcessChain;
import com.manatee.process.ProcessDataSource;
import com.manatee.process.domain.ProcessContent;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Service
public class TransactionProcessV2
implements IProcess {
    private Logger log = LoggerFactory.getLogger(TransactionProcessV2.class);
    @Resource
    private ProcessChain processChain;
    @Resource
    private ProcessConfUtil processConfUtil;
    @Resource
    private IVariableUtil variableUtil;
    @Resource
    private ApplicationContext applicationContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"steps"});
        String db = this.variableUtil.calVarInConf(content, "db");
        String transactionIsolationLevel = this.variableUtil.calVarInConf(content, "transactionIsolationLevel");
        JSONObject conf = content.getStepConf();
        Connection transactionCon = null;
        boolean opneTransactionConFlag = false;
        PlatformTransactionManager transactionManager = this.getTransactionManager(db);
        DataSource ds = this.getDataSource(db);
        DefaultTransactionDefinition txDef = new DefaultTransactionDefinition();
        TransactionStatus txStatus = null;
        try {
            if (StringUtils.isNotBlank((CharSequence)transactionIsolationLevel)) {
                int isolationLevel = 0;
                switch (transactionIsolationLevel) {
                    case "read_uncommitted": {
                        isolationLevel = 1;
                        break;
                    }
                    case "read_committed": {
                        isolationLevel = 2;
                        break;
                    }
                    case "repeatable_read": {
                        isolationLevel = 4;
                        break;
                    }
                    case "serializable": {
                        isolationLevel = 8;
                        break;
                    }
                }
                txDef.setIsolationLevel(isolationLevel);
            }
            txStatus = transactionManager.getTransaction((TransactionDefinition)txDef);
            if (content.getTransactionCon() == null) {
                opneTransactionConFlag = true;
                transactionCon = DataSourceUtils.getConnection((DataSource)ds);
                transactionCon.setAutoCommit(false);
            } else {
                transactionCon = content.getTransactionCon();
            }
            content.setTransactionCon(transactionCon);
            this.doSteps(content, conf);
        }
        catch (Throwable e) {
            block45: {
                block44: {
                    this.log.warn("\u53d1\u751f\u5f02\u5e38\uff0c\u4e8b\u52a1\u56de\u6eda");
                    if (!Objects.nonNull(txStatus)) break block44;
                    transactionManager.rollback(txStatus);
                }
                try {
                    if (transactionCon != null) {
                        DataSourceUtils.doCloseConnection((Connection)transactionCon, (DataSource)ds);
                        content.setTransactionCon(null);
                        this.log.warn("\u4e8b\u52a1\u6570\u636e\u5e93\u94fe\u63a5\u5173\u95ed");
                    }
                    break block45;
                }
                catch (SQLException throwables) {
                    throwables.printStackTrace();
                }
                break block45;
                catch (TransactionException te) {
                    try {
                        te.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        try {
                            if (transactionCon != null) {
                                DataSourceUtils.doCloseConnection(transactionCon, (DataSource)ds);
                                content.setTransactionCon(null);
                                this.log.warn("\u4e8b\u52a1\u6570\u636e\u5e93\u94fe\u63a5\u5173\u95ed");
                            }
                        }
                        catch (SQLException throwables) {
                            throwables.printStackTrace();
                        }
                        throw throwable;
                    }
                    try {
                        if (transactionCon != null) {
                            DataSourceUtils.doCloseConnection((Connection)transactionCon, (DataSource)ds);
                            content.setTransactionCon(null);
                            this.log.warn("\u4e8b\u52a1\u6570\u636e\u5e93\u94fe\u63a5\u5173\u95ed");
                        }
                    }
                    catch (SQLException throwables) {
                        throwables.printStackTrace();
                    }
                }
            }
            BizException bizException = null;
            if (e instanceof BizException) {
                bizException = (BizException)e;
                throw bizException;
            }
            bizException = new BizException(ResultCode.BIZ_ERROR, "cal_transactionProcess_error", e);
            String id = conf.getString("id");
            String title = conf.getString("title");
            bizException.setId(id);
            bizException.setStepName("transactionProcess");
            bizException.setStepTitle(title);
            throw bizException;
        }
        try {
            if (opneTransactionConFlag) {
                this.log.info("\u63d0\u4ea4\u4e8b\u52a1");
                transactionManager.commit(txStatus);
            }
        }
        catch (TransactionException te) {
            this.log.error("transactionCon commit error", (Throwable)te);
        }
        finally {
            try {
                if (transactionCon != null && opneTransactionConFlag) {
                    DataSourceUtils.doCloseConnection((Connection)transactionCon, (DataSource)ds);
                    content.setTransactionCon(null);
                }
            }
            catch (SQLException throwables) {
                throwables.printStackTrace();
            }
        }
    }

    private void doSteps(ProcessContent content, JSONObject conf) throws BizException {
        List steps = ProcessDataSource.formatSteps((JSONObject)conf);
        this.processChain.executeSteps(content, steps);
    }

    public PlatformTransactionManager getTransactionManager(String db) {
        PlatformTransactionManager transactionManager = (PlatformTransactionManager)this.applicationContext.getBean(PlatformTransactionManager.class);
        return transactionManager;
    }

    public DataSource getDataSource(String db) throws BizException {
        return (DataSource)this.applicationContext.getBean(DataSource.class);
    }

    public String getName() {
        return "transactionProcessV2";
    }
}

