/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.manager;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.DBQuery;
import com.manatee.common.domain.In;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.CollectionUtils;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcode.iutil.IDbReadUtil;
import com.manatee.lowcode.iutil.IJoinManager;
import com.manatee.lowcode.util.DBUtil;
import com.manatee.lowcode.util.InputUtil;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.domain.Step;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class JoinManager
implements IJoinManager {
    @Resource
    private InputUtil inputUtil;
    @Resource
    private DBUtil dbUtil;
    private String BE_JOINED_KEY = "beJoinedKey";
    private String JOIN_KEY = "joinKey";
    private String DB_TYPE = "dbType";

    public void join(ProcessContent content, DBQuery dbQuery, JSON data) throws BizException {
        JSONArray joinArray = dbQuery.getJoin();
        if (CollectionUtils.isNotEmpty((Collection)joinArray)) {
            for (int i = 0; i < joinArray.size(); ++i) {
                JSONObject aConf = joinArray.getJSONObject(i);
                Step step = content.getStep();
                step.setTempConf(aConf);
                this.doAJoin(content, data);
                step.removeTempConf();
            }
        }
    }

    private JSON doAJoin(ProcessContent content, JSON data) throws BizException {
        JSONObject value;
        JSONArray array = new JSONArray();
        if (data instanceof JSONObject) {
            array.add((Object)data);
        } else if (data != null) {
            array = (JSONArray)data;
        } else {
            return null;
        }
        JSONObject conf = content.getStepConf();
        String joinKey = conf.getString(this.JOIN_KEY);
        String beJoinedKey = conf.getString(this.BE_JOINED_KEY);
        ArrayList<Object> inValue = new ArrayList<Object>();
        HashMap<Object, String> inValueMap = new HashMap<Object, String>();
        for (int i = 0; i < array.size(); ++i) {
            value = array.getJSONObject(i);
            Object joinPrimaryValue = value.get((Object)joinKey);
            if (joinPrimaryValue == null || inValueMap.get(joinPrimaryValue) != null) continue;
            inValueMap.put(joinPrimaryValue, "1");
            inValue.add(joinPrimaryValue);
        }
        DBQuery dbQuery = this.getDbQuery(content, beJoinedKey, inValue);
        value = this.doQuery(conf, dbQuery);
        return this.joinList(content, data, (JSON)value);
    }

    private JSON doQuery(JSONObject conf, DBQuery dbQuery) throws BizException {
        String dbType = conf.getString(this.DB_TYPE);
        IDbReadUtil dbReadUtil = this.getDbUtil(dbType);
        if (dbReadUtil == null) {
            throw new BizException(ResultCode.PARAM_IS_ERROR, dbType + "_bean_not_exist");
        }
        return dbReadUtil.find(dbQuery);
    }

    private IDbReadUtil getDbUtil(String dbType) {
        IDbReadUtil dbReadUtil = null;
        if (StringUtil.isBlank((String)dbType)) {
            dbReadUtil = (IDbReadUtil)this.dbUtil.getBean("mongo");
            if (dbReadUtil == null) {
                dbReadUtil = (IDbReadUtil)this.dbUtil.getBean("mysql");
            }
        } else {
            dbReadUtil = (IDbReadUtil)this.dbUtil.getBean(dbType);
        }
        return dbReadUtil;
    }

    private JSON joinList(ProcessContent content, JSON join, JSON beJoin) throws BizException {
        JSONObject conf = content.getStepConf();
        String beJoinPrimaryKey = (String)conf.get((Object)this.BE_JOINED_KEY);
        String joinPrimaryKey = (String)conf.get((Object)this.JOIN_KEY);
        Map<Object, JSONObject> joinMap = this.getJoinMap(content, beJoin, beJoinPrimaryKey);
        if (join instanceof JSONObject) {
            JSONObject aJson = (JSONObject)join;
            this.joinByPrimaryKey(aJson, joinMap, joinPrimaryKey);
            return aJson;
        }
        if (join instanceof JSONArray) {
            JSONArray array = (JSONArray)join;
            for (int i = 0; i < array.size(); ++i) {
                JSONObject aJson = array.getJSONObject(i);
                this.joinByPrimaryKey(aJson, joinMap, joinPrimaryKey);
            }
        }
        return null;
    }

    private void joinByPrimaryKey(JSONObject join, Map<Object, JSONObject> joinMap, String joinPrimaryKey) {
        Object value = join.get((Object)joinPrimaryKey);
        JSONObject joinJson = joinMap.get(value);
        if (joinJson == null) {
            return;
        }
        for (String key : joinJson.keySet()) {
            Object joinValue;
            Object aValue = join.get((Object)key);
            if (aValue != null || (joinValue = joinJson.get((Object)key)) == null) continue;
            join.put(key, joinValue);
        }
    }

    private Map<Object, JSONObject> getJoinMap(ProcessContent content, JSON beJoin, String beJoinPrimaryKey) throws BizException {
        HashMap<Object, JSONObject> beJoinMap = new HashMap<Object, JSONObject>();
        if (beJoin instanceof JSONObject) {
            JSONObject json = (JSONObject)beJoin;
            JSONObject newJson = this.filter(content, json);
            Object value = json.get((Object)beJoinPrimaryKey);
            beJoinMap.put(value, newJson);
        } else if (beJoin instanceof JSONArray) {
            JSONArray json = (JSONArray)beJoin;
            for (int i = 0; i < json.size(); ++i) {
                JSONObject aJson = json.getJSONObject(i);
                JSONObject newJson = this.filter(content, aJson);
                Object value = aJson.get((Object)beJoinPrimaryKey);
                beJoinMap.put(value, newJson);
            }
        }
        return beJoinMap;
    }

    private JSONObject filter(ProcessContent content, JSONObject aJson) throws BizException {
        content.setTempConf(aJson);
        Map query = this.inputUtil.getHandleObject(content, "params");
        content.removeTempConf();
        if (query == null || query.size() == 0) {
            return aJson;
        }
        JSONObject json = new JSONObject();
        json.putAll(query);
        return json;
    }

    private DBQuery getDbQuery(ProcessContent content, String beJoinPrimaryKey, List inValue) throws BizException {
        DBQuery dbQuery = new DBQuery();
        JSONObject aConf = content.getStepConf();
        String db = aConf.getString("db");
        if (StringUtil.isBlank((String)db)) {
            db = (String)content.getStep().getTopConf("db");
        }
        dbQuery.setDb(db);
        dbQuery.setTable(aConf.getString("table"));
        ArrayList<In> inList = new ArrayList<In>();
        if (inValue.size() > 1) {
            In in = new In();
            in.setKey(beJoinPrimaryKey);
            in.setValue(inValue);
            inList.add(in);
            dbQuery.setIn(inList);
        } else if (inValue.size() == 1) {
            dbQuery.putConditionMap(beJoinPrimaryKey, inValue.get(0));
        }
        Map param = this.inputUtil.getHandleObject(content, "queryParams");
        dbQuery.addAllConditionMap(param);
        return dbQuery;
    }
}

