/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.function.collection;

import com.manatee.fun.AbstractFunction;
import com.manatee.fun.domain.FunctionContent;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ListContainsFun
extends AbstractFunction {
    public String getName() {
        return "listContains";
    }

    public Object doFunction(FunctionContent content) {
        this.checkParamSize(content);
        this.checkParamExist(content);
        List parameters = content.getParameters();
        Object collectionObj = parameters.get(0);
        Object valueObj = parameters.get(1);
        if (valueObj == null && content.getParamKeys().size() == 2 && (content.getParamKeys(1).equals("true") || content.getParamKeys(1).equals("false"))) {
            valueObj = Boolean.parseBoolean(content.getParamKeys(1));
        }
        if (collectionObj instanceof Collection) {
            Collection collection = (Collection)collectionObj;
            if (valueObj instanceof Collection) {
                Collection valueCollection = (Collection)valueObj;
                return collection.containsAll(valueCollection);
            }
            return collection.contains(valueObj);
        }
        return false;
    }

    public Integer getMinParamSize() {
        return 2;
    }

    public Integer getMaxParamSize() {
        return 2;
    }
}

